/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import lambda.gui.lambdalabel.LambdaLabel;

public class LambdaLabelStringBuilder {
    private static VisitorImpl visitor = new VisitorImpl();

    public static String toString(LambdaLabel lambdaLabel) {
        StringBuilder stringBuilder = new StringBuilder();
        lambdaLabel.accept(visitor, stringBuilder);
        return stringBuilder.toString();
    }

    private static class VisitorImpl
    implements LambdaLabel.VisitorP<StringBuilder> {
        private VisitorImpl() {
        }

        @Override
        public void visit(LambdaLabel.LiteralLabel literalLabel, StringBuilder stringBuilder) {
            stringBuilder.append(literalLabel.name);
        }

        @Override
        public void visit(LambdaLabel.ApplyLabel applyLabel, StringBuilder stringBuilder) {
            boolean bl = applyLabel.lexpr.isParenRequiredInAppLeft();
            boolean bl2 = applyLabel.rexpr.isParenRequiredInAppRight();
            if (bl) {
                stringBuilder.append('(');
            }
            applyLabel.lexpr.accept(this, stringBuilder);
            if (bl) {
                stringBuilder.append(')');
            }
            if (bl2) {
                stringBuilder.append('(');
            }
            applyLabel.rexpr.accept(this, stringBuilder);
            if (bl2) {
                stringBuilder.append(')');
            }
        }

        @Override
        public void visit(LambdaLabel.AbstractLabel abstractLabel, StringBuilder stringBuilder) {
            LambdaLabel lambdaLabel = abstractLabel;
            stringBuilder.append('\\');
            while (((LambdaLabel)lambdaLabel).isAbstract()) {
                LambdaLabel.AbstractLabel abstractLabel2 = lambdaLabel;
                stringBuilder.append(abstractLabel2.name);
                lambdaLabel = abstractLabel2.body;
            }
            stringBuilder.append('.');
            ((LambdaLabel)lambdaLabel).accept(this, stringBuilder);
        }

        @Override
        public void visit(LambdaLabel.MacroLabel macroLabel, StringBuilder stringBuilder) {
            stringBuilder.append('<');
            stringBuilder.append(macroLabel.name);
            stringBuilder.append('>');
        }

        @Override
        public void visit(LambdaLabel.RedexWrapper redexWrapper, StringBuilder stringBuilder) {
            redexWrapper.lambda.accept(this, stringBuilder);
        }
    }
}

