/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import lambda.Environment;
import lambda.gui.Main;
import lambda.gui.fontdialog.FontDialog;
import lambda.gui.fontdialog.event.FontUpdateListener;

public class MainMenu
extends JMenuBar {
    private JFrame owner;

    public MainMenu(JFrame jFrame) {
        this.owner = jFrame;
        this.setBorder(null);
        JMenu jMenu = new JMenu("File");
        this.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.owner.dispose();
            }
        });
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("View");
        this.add(jMenu2);
        JMenuItem jMenuItem2 = new JMenuItem("Font");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final Environment environment = Environment.getEnvironment();
                String string = environment.get("gui.fontfamily", "");
                int n = environment.getInt("gui.fontsize", 12);
                int n2 = environment.getInt("gui.ui.font.addition", 0);
                FontDialog fontDialog = new FontDialog();
                fontDialog.setLocationRelativeTo(MainMenu.this.owner);
                fontDialog.setSelectedFamilyName(string);
                fontDialog.setSelectedFontSize(n);
                fontDialog.setFontAddition(n2);
                fontDialog.addFontApplyListener(new FontUpdateListener(){

                    @Override
                    public void fontFamilyChanged(String string) {
                        environment.set("gui.fontfamily", string);
                        Main.reload(environment.getGUIFont());
                    }

                    @Override
                    public void fontSizeChanged(int n) {
                        environment.set("gui.fontsize", n);
                        Main.reload(environment.getGUIFont());
                    }

                    @Override
                    public void uiFontAdditionChanged(int n) {
                        environment.set("gui.ui.font.addition", n);
                        Main.updateUIFontAddition();
                    }
                });
                if (!fontDialog.showModal()) {
                    environment.set("gui.fontfamily", string);
                    environment.set("gui.fontsize", n);
                    environment.set("gui.ui.font.addition", n2);
                    Main.reload(environment.getGUIFont());
                    Main.updateUIFontAddition();
                }
            }
        });
        jMenu2.add(jMenuItem2);
        JMenu jMenu3 = new JMenu("About");
        this.add(jMenu3);
        JMenuItem jMenuItem3 = new JMenuItem("Version");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainMenu.this.showVersion();
            }
        });
        jMenu3.add(jMenuItem3);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(null);
    }

    private void showVersion() {
        String string = "";
        string = string + "Lambda * Magica version 3.80\n";
        string = string + "Release Date: 2012-12-06\n";
        string = string + "Copyright (C) 2011-2012 Yuuki.S All Rights Reserved.";
        JOptionPane.showMessageDialog(this.owner, string, "Version Information", 1);
    }
}

