/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class VariableCollector {
    private Collector collector = new Collector();

    public VariableCollector(Lambda lambda) {
        lambda.accept(this.collector);
    }

    public Set<String> getFreeVariables() {
        return Collections.unmodifiableSet(this.collector.fv);
    }

    public Set<String> getBoundedVariables() {
        return Collections.unmodifiableSet(this.collector.bv);
    }

    private static class Collector
    implements Lambda.Visitor {
        private Set<String> fv = new HashSet<String>();
        private Set<String> bv = new HashSet<String>();

        private Collector() {
        }

        @Override
        public void visit(ASTAbstract aSTAbstract) {
            this.bv.add(aSTAbstract.name);
            aSTAbstract.e.accept(this);
            this.fv.remove(aSTAbstract.name);
        }

        @Override
        public void visit(ASTApply aSTApply) {
            aSTApply.lexpr.accept(this);
            aSTApply.rexpr.accept(this);
        }

        @Override
        public void visit(ASTLiteral aSTLiteral) {
            this.fv.add(aSTLiteral.name);
        }

        @Override
        public void visit(ASTMacro aSTMacro) {
        }
    }
}

