/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class IDContext {
    protected Set<String> boundedNames = new HashSet<String>();
    protected Map<String, Integer> ids = new HashMap<String, Integer>();

    public Set<String> getBoundedNames() {
        return Collections.unmodifiableSet(this.boundedNames);
    }

    public void addBoundedName(String string) {
        this.boundedNames.add(string);
    }

    public boolean isBounded(String string) {
        return this.boundedNames.contains(string);
    }

    public int define(String string) {
        int n = this.generateFreshId();
        this.ids.put(string, n);
        return n;
    }

    public abstract int find(String var1);

    protected abstract int generateFreshId();

    public static IDContext createContext() {
        return new RootContext();
    }

    public static IDContext deriveContext(IDContext iDContext) {
        return new SubContext(iDContext);
    }

    private static class SubContext
    extends IDContext {
        private final IDContext superContext;

        public SubContext(IDContext iDContext) {
            this.superContext = iDContext;
            this.boundedNames.addAll(iDContext.boundedNames);
        }

        @Override
        public int find(String string) {
            Integer n = (Integer)this.ids.get(string);
            if (n == null) {
                n = this.superContext.find(string);
            }
            return n;
        }

        @Override
        protected int generateFreshId() {
            return this.superContext.generateFreshId();
        }
    }

    private static class RootContext
    extends IDContext {
        private int freshId;

        private RootContext() {
        }

        @Override
        public int find(String string) {
            Integer n = (Integer)this.ids.get(string);
            if (n == null) {
                n = this.define(string);
            }
            return n;
        }

        @Override
        protected int generateFreshId() {
            return this.freshId++;
        }
    }
}

