/*
 * Decompiled with CFR 0.152.
 */
package lambda.reduction;

import java.util.Set;
import lambda.Environment;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IDContext;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.VariableCollector;
import lambda.reduction.ReductionRule;

public class Reducer {
    private static ReductionVisitor visitor;

    public static Result reduce(Lambda lambda, Environment environment, IRedex iRedex) {
        if (lambda == null || environment == null || iRedex == null) {
            throw new NullPointerException();
        }
        if (visitor == null) {
            visitor = new ReductionVisitor();
        }
        visitor.env = environment;
        visitor.redex = iRedex;
        return visitor.reduce(lambda);
    }

    private static class ReductionVisitor
    implements Lambda.VisitorRP<Lambda, IDContext> {
        private Environment env;
        private IRedex redex;
        private ReductionRule appliedRule = ReductionRule.NONE;

        private ReductionVisitor() {
        }

        @Override
        public Lambda visit(ASTAbstract aSTAbstract, IDContext iDContext) {
            Lambda lambda;
            Object object;
            if (aSTAbstract == this.redex && aSTAbstract.e.isApplication()) {
                object = (ASTApply)aSTAbstract.e;
                if (((ASTApply)object).rexpr.isLiteral()) {
                    VariableCollector variableCollector;
                    Set<String> set;
                    lambda = (ASTLiteral)((ASTApply)object).rexpr;
                    if (aSTAbstract.name.equals(((ASTLiteral)lambda).name) && !(set = (variableCollector = new VariableCollector(((ASTApply)object).lexpr)).getFreeVariables()).contains(((ASTLiteral)lambda).name)) {
                        this.appliedRule = ReductionRule.ETA_REDUCTION;
                        return ((ASTApply)object).lexpr;
                    }
                }
            }
            object = IDContext.deriveContext(iDContext);
            ((IDContext)object).addBoundedName(aSTAbstract.name);
            lambda = this.reduce(aSTAbstract.e, (IDContext)object);
            if (lambda != aSTAbstract.e) {
                return new ASTAbstract(aSTAbstract.originalName, aSTAbstract.name, lambda);
            }
            return aSTAbstract;
        }

        @Override
        public Lambda visit(ASTApply aSTApply, IDContext iDContext) {
            if (aSTApply == this.redex && aSTApply.lexpr.isAbstraction()) {
                ASTAbstract aSTAbstract = (ASTAbstract)aSTApply.lexpr;
                this.appliedRule = ReductionRule.BETA_REDUCTION;
                return aSTAbstract.apply(iDContext, aSTApply.rexpr);
            }
            Lambda lambda = this.reduce(aSTApply.lexpr, iDContext);
            if (lambda != aSTApply.lexpr) {
                return new ASTApply(lambda, aSTApply.rexpr);
            }
            lambda = this.reduce(aSTApply.rexpr, iDContext);
            if (lambda != aSTApply.rexpr) {
                return new ASTApply(aSTApply.lexpr, lambda);
            }
            return aSTApply;
        }

        @Override
        public Lambda visit(ASTLiteral aSTLiteral, IDContext iDContext) {
            return aSTLiteral;
        }

        @Override
        public Lambda visit(ASTMacro aSTMacro, IDContext iDContext) {
            Lambda lambda;
            if (aSTMacro == this.redex && (lambda = this.env.expandMacro(aSTMacro.name)) != null) {
                this.appliedRule = ReductionRule.MACRO_EXPANSION;
                return lambda;
            }
            return aSTMacro;
        }

        public Result reduce(Lambda lambda) {
            Lambda lambda2;
            return new Result(lambda2, this.appliedRule, (lambda2 = this.reduce(lambda, IDContext.createContext())) != lambda);
        }

        private Lambda reduce(Lambda lambda, IDContext iDContext) {
            return lambda.accept(this, iDContext);
        }
    }

    public static class Result {
        public final Lambda lambda;
        public final ReductionRule appliedRule;
        public final boolean reduced;

        public Result(Lambda lambda, ReductionRule reductionRule, boolean bl) {
            this.lambda = lambda;
            this.appliedRule = reductionRule;
            this.reduced = bl;
        }
    }
}

