/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.Font;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import lambda.Environment;
import lambda.gui.MainFrame;
import lambda.gui.util.GUIUtils;

public class Main {
    private static MainFrame mainFrame;
    private static Map<String, Integer> defaultSizes;

    public static void reload(Font font) {
        mainFrame.setCodeFont(font);
    }

    public static void updateUIFontAddition() {
        Object object;
        if (defaultSizes == null) {
            defaultSizes = new HashMap<String, Integer>();
            for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
                String object2 = entry.getKey().toString();
                if (!object2.toLowerCase().endsWith("font")) continue;
                object = UIManager.getFont(object2);
                defaultSizes.put(object2, ((Font)object).getSize());
            }
        }
        int n = Environment.getEnvironment().getInt("gui.ui.font.addition", 0);
        for (Map.Entry<String, Integer> entry : defaultSizes.entrySet()) {
            object = entry.getKey();
            Font font = UIManager.getFont(object);
            float f = entry.getValue() + n;
            if (!(f > 0.0f)) continue;
            UIManager.put(object, new FontUIResource(font.deriveFont(f)));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Window window : Window.getWindows()) {
                        SwingUtilities.updateComponentTreeUI(window);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        GUIUtils.preloadFontNames();
        GUIUtils.setLookAndFeelToSystem();
        mainFrame = new MainFrame();
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setLocationRelativeTo(null);
        mainFrame.setVisible(true);
    }

    static {
        defaultSizes = null;
    }
}

