/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast.parser;

import java.util.Scanner;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import lambda.ast.parser.Lexer;
import lambda.ast.parser.LexerException;
import lambda.ast.parser.ParserException;
import lambda.ast.parser.Token;
import lambda.ast.parser.TokenType;

public class Parser {
    private Lexer lexer;
    private Token token;

    public Parser(Lexer lexer) {
        this.lexer = lexer;
    }

    public Lambda parse() throws ParserException {
        this.next();
        Lambda lambda = this.abstraction();
        if (this.token.type == TokenType.END) {
            return lambda;
        }
        throw new ParserException("Syntax error, extra tokens.", this.token);
    }

    private Lambda abstraction() throws ParserException {
        if (this.token.type == TokenType.LAMBDA) {
            this.next();
            if (this.token.type == TokenType.ID) {
                String string = this.token.text;
                this.next();
                return new ASTAbstract(string, string, this.absList());
            }
            if (this.token.type == TokenType.DOT) {
                throw new ParserException("Syntax error, empty formals.", this.token);
            }
            throw new ParserException("Syntax error, expected variable names.", this.token);
        }
        return this.appList();
    }

    private Lambda absList() throws ParserException {
        if (this.token.type == TokenType.ID) {
            String string = this.token.text;
            this.next();
            return new ASTAbstract(string, string, this.absList());
        }
        if (this.token.type == TokenType.DOT) {
            this.next();
            return this.abstraction();
        }
        throw new ParserException("Syntax error, unexpected token.", this.token);
    }

    private Lambda appList() throws ParserException {
        Lambda lambda = this.atomic();
        TokenType tokenType = this.token.type;
        while (tokenType == TokenType.ID || tokenType == TokenType.LPAR || tokenType == TokenType.MACRONAME) {
            lambda = new ASTApply(lambda, this.atomic());
            tokenType = this.token.type;
        }
        return lambda;
    }

    private Lambda atomic() throws ParserException {
        switch (this.token.type) {
            case ID: {
                String string = this.token.text;
                this.next();
                return new ASTLiteral(string);
            }
            case MACRONAME: {
                String string = this.token.text;
                this.next();
                return new ASTMacro(string);
            }
            case LPAR: {
                this.next();
                Lambda lambda = this.abstraction();
                if (this.token.type != TokenType.RPAR) {
                    throw new ParserException("Syntax error, missing ')'.", this.token);
                }
                this.next();
                return lambda;
            }
        }
        throw new ParserException("Syntax error, unexpected token.", this.token);
    }

    private void next() throws ParserException {
        try {
            this.token = this.lexer.nextToken();
        }
        catch (LexerException lexerException) {
            throw new ParserException("Lexical error, " + lexerException.getMessage(), lexerException.column);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Type :q to quit.");
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.print("> ");
            String string = scanner.nextLine();
            if (string == null || string.equals(":q")) break;
            Parser parser = new Parser(new Lexer(string));
            try {
                Lambda lambda = parser.parse();
                System.out.println("parsed: " + lambda);
            }
            catch (ParserException parserException) {
                System.out.println(string);
                for (int i = 0; i < parserException.column; ++i) {
                    System.out.print(' ');
                }
                System.out.println('^');
                System.out.println(parserException.getMessage());
            }
        }
    }
}

