/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lambda.AlphaComparator;
import lambda.Environment;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.RedexFinder;
import lambda.reduction.Reducer;
import lambda.reduction.ReductionRule;

public class LambdaInterpreter {
    private LinkedList<State> states = new LinkedList();
    private State currentState;
    private Lambda sourceLambda;
    private boolean isCyclic;
    private boolean terminated;

    public void startInterpretation(Lambda lambda) {
        this.sourceLambda = lambda;
        this.initialize();
    }

    public void initialize() {
        this.isCyclic = false;
        this.terminated = false;
        this.states.clear();
        this.pushState(new State(0, this.sourceLambda, ReductionRule.NONE));
    }

    public Reducer.Result step(Environment environment, IRedex iRedex) {
        Reducer.Result result = Reducer.reduce(this.getLambda(), environment, iRedex);
        this.isCyclic = AlphaComparator.alphaEquiv(this.getLambda(), result.lambda);
        ReductionRule reductionRule = result.appliedRule;
        int n = this.currentState.stepNumber;
        if (reductionRule == ReductionRule.BETA_REDUCTION || reductionRule == ReductionRule.ETA_REDUCTION) {
            ++n;
        }
        this.currentState.redex = iRedex;
        this.pushState(new State(n, result.lambda, reductionRule));
        return result;
    }

    public void revert() {
        this.pop();
    }

    public boolean isRevertable() {
        return this.states.size() > 1;
    }

    public int getReductionStepCount() {
        return this.currentState.stepNumber;
    }

    public boolean isNormal() {
        boolean bl = Environment.getEnvironment().getBoolean("eta_reduction");
        return RedexFinder.isNormalForm(this.getLambda(), bl);
    }

    public boolean isCyclic() {
        return !this.isNormal() && this.isCyclic;
    }

    public boolean isTerminated() {
        return this.terminated || this.isNormal() || this.isCyclic();
    }

    public void terminate() {
        this.terminated = true;
    }

    public Lambda getLambda() {
        return this.currentState.lambda;
    }

    public List<State> getStates() {
        return Collections.unmodifiableList(this.states);
    }

    private void pushState(State state) {
        this.states.addLast(state);
        this.currentState = state;
    }

    private void pop() {
        if (this.isRevertable()) {
            this.states.removeLast();
            this.currentState = this.states.getLast();
        }
    }

    public static class State {
        public final int stepNumber;
        public final Lambda lambda;
        public final ReductionRule appliedRule;
        private IRedex redex;

        public State(int n, Lambda lambda, ReductionRule reductionRule) {
            this.stepNumber = n;
            this.lambda = lambda;
            this.appliedRule = reductionRule;
        }

        public IRedex getReducedRedex() {
            return this.redex;
        }
    }
}

