/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import lambda.ast.Lambda;

public class Environment {
    public static final String APPLICATION_VERSION = "3.72";
    public static final String RELEASE_DATE = "2012-12-04";
    public static final String PROPERTY_FILENAME = "properties.txt";
    public static final String KEY_CONTINUE_STEPS = "continue_steps";
    public static final String KEY_PRINT_STEP = "print_step";
    public static final String KEY_TRACE = "trace";
    public static final String KEY_SHORT = "short";
    public static final String KEY_DATA_CONV = "data_abstraction";
    public static final String KEY_AUTO = "auto";
    public static final String KEY_ETA_REDUCTION = "eta_reduction";
    public static final String KEY_GUI_FONT_FAMILY = "gui.fontfamily";
    public static final String KEY_GUI_FONT_SIZE = "gui.fontsize";
    public static final String KEY_GUI_FONT_ADDITION = "gui.ui.font.addition";
    public static final String KEY_PRINT_BETA_ETA = "print_beta_eta";
    private static Environment instance;
    private Map<String, Lambda> macros = new TreeMap<String, Lambda>();
    private Map<String, String> entries = new TreeMap<String, String>();
    private Font guiFont;

    private Environment() {
        this.set(KEY_CONTINUE_STEPS, 500);
        this.set(KEY_TRACE, false);
        this.set(KEY_SHORT, true);
        this.set(KEY_DATA_CONV, false);
        this.set(KEY_AUTO, false);
        this.set(KEY_ETA_REDUCTION, false);
        this.set(KEY_GUI_FONT_FAMILY, "DialogInput");
        this.set(KEY_GUI_FONT_SIZE, 12);
        this.set(KEY_GUI_FONT_ADDITION, 0);
        this.set(KEY_PRINT_BETA_ETA, true);
    }

    public void defineMacro(String string, Lambda lambda) {
        this.macros.put(string, lambda);
    }

    public Lambda expandMacro(String string) {
        return this.macros.get(string);
    }

    public void dumpMacros() {
        for (Map.Entry<String, Lambda> entry : this.macros.entrySet()) {
            Environment.echoMacro(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, Lambda> getDefinedMacros() {
        return Collections.unmodifiableMap(this.macros);
    }

    private static void echoMacro(String string, Lambda lambda) {
        System.out.println(Environment.getMacroString(string, "=", lambda));
    }

    private static String getMacroString(String string, String string2, Lambda lambda) {
        return String.format("- <%s> %s %s", string, string2, lambda);
    }

    public void clearMacros() {
        this.macros.clear();
    }

    public String get(String string, String string2) {
        String string3 = this.entries.get(string);
        if (string3 == null) {
            string3 = string2;
            this.set(string, string3);
        }
        return string3;
    }

    public int getInt(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(this.entries.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n;
            this.set(string, n2);
        }
        return n2;
    }

    public boolean getBoolean(String string) {
        String string2 = this.entries.get(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        this.set(string, false);
        return false;
    }

    public <T> void set(String string, T t) {
        this.entries.put(string, t.toString());
    }

    public Font getGUIFont() {
        String string = this.get(KEY_GUI_FONT_FAMILY, "DialogInput");
        int n = this.getInt(KEY_GUI_FONT_SIZE, 12);
        if (this.guiFont == null || !this.guiFont.getFamily().equals(string) || this.guiFont.getSize() != n) {
            this.guiFont = new Font(string, 0, n);
        }
        return this.guiFont;
    }

    public static Environment getEnvironment() {
        if (instance == null) {
            Environment.createEnvironment();
        }
        return instance;
    }

    private static void createEnvironment() {
        instance = new Environment();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(PROPERTY_FILENAME)));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("\\s*=\\s*");
                if (stringArray.length != 2) continue;
                Environment.instance.entries.put(stringArray[0].trim(), stringArray[1].trim());
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                instance.save();
            }
        });
    }

    private void save() {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(PROPERTY_FILENAME))));
            for (Map.Entry<String, String> entry : this.entries.entrySet()) {
                printWriter.println(entry.getKey() + "=" + entry.getValue());
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }
}

