/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lambda.Environment;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.RedexFinder;
import lambda.ast.parser.ParserException;
import lambda.reduction.Reducer;
import lambda.stategraph.IStateNode;
import lambda.stategraph.InfinityNode;
import lambda.stategraph.LambdaNode;
import lambda.stategraph.gui.GraphNode;
import lambda.stategraph.gui.StateFrame;

public class NDMain {
    private static Set<IStateNode> states = new HashSet<IStateNode>();
    private static Map<LambdaNode, Set<IStateNode>> edges = new HashMap<LambdaNode, Set<IStateNode>>();
    private static Map<IStateNode, GraphNode> nodeMapping = new HashMap<IStateNode, GraphNode>();
    private static boolean createdNew;

    private static void addEdge(LambdaNode lambdaNode, IStateNode iStateNode) {
        Set<IStateNode> set = edges.get(lambdaNode);
        if (set == null) {
            set = new HashSet<IStateNode>();
            edges.put(lambdaNode, set);
        }
        set.add(iStateNode);
    }

    private static GraphNode addGraphNode(StateFrame stateFrame, IStateNode iStateNode) {
        GraphNode graphNode = nodeMapping.get(iStateNode);
        if (graphNode == null) {
            graphNode = new GraphNode(iStateNode.getText());
            nodeMapping.put(iStateNode, graphNode);
            stateFrame.addNode(graphNode);
            createdNew = true;
        } else {
            createdNew = false;
        }
        return graphNode;
    }

    private static void search(Lambda lambda, int n) {
        Environment environment = Environment.getEnvironment();
        LinkedList<LambdaNode> linkedList = new LinkedList<LambdaNode>();
        linkedList.add(new LambdaNode(0, lambda));
        while (!linkedList.isEmpty()) {
            LambdaNode lambdaNode = (LambdaNode)linkedList.poll();
            if (states.contains(lambdaNode)) continue;
            states.add(lambdaNode);
            List<IRedex> list = RedexFinder.getRedexList(lambdaNode.lambda);
            for (IRedex iRedex : list) {
                Reducer.Result result = Reducer.reduce(lambdaNode.lambda, environment, iRedex);
                LambdaNode lambdaNode2 = new LambdaNode(lambdaNode.depth + 1, result.lambda);
                if (lambdaNode.depth + 1 <= n || states.contains(lambdaNode2)) {
                    NDMain.addEdge(lambdaNode, lambdaNode2);
                    linkedList.add(lambdaNode2);
                    continue;
                }
                NDMain.addEdge(lambdaNode, InfinityNode.getInstance());
            }
        }
        System.out.println("states = " + states.size());
    }

    private static void searchOnLine(Lambda lambda, int n) {
        StateFrame stateFrame = new StateFrame();
        stateFrame.setDefaultCloseOperation(3);
        stateFrame.setVisible(true);
        Environment environment = Environment.getEnvironment();
        nodeMapping.clear();
        LinkedList<LambdaNode> linkedList = new LinkedList<LambdaNode>();
        LambdaNode lambdaNode = new LambdaNode(0, lambda);
        GraphNode graphNode = NDMain.addGraphNode(stateFrame, lambdaNode);
        stateFrame.setInitialNode(graphNode);
        linkedList.add(lambdaNode);
        while (!linkedList.isEmpty()) {
            LambdaNode lambdaNode2 = (LambdaNode)linkedList.poll();
            if (states.contains(lambdaNode2)) continue;
            states.add(lambdaNode2);
            GraphNode graphNode2 = NDMain.addGraphNode(stateFrame, lambdaNode2);
            List<IRedex> list = lambdaNode2.getRedexes();
            if (list.isEmpty()) {
                graphNode2.setAccept(true);
            }
            for (IRedex iRedex : list) {
                GraphNode graphNode3;
                Reducer.Result result = Reducer.reduce(lambdaNode2.lambda, environment, iRedex);
                LambdaNode lambdaNode3 = new LambdaNode(lambdaNode2.depth + 1, result.lambda);
                if (lambdaNode3.depth <= n || states.contains(lambdaNode3)) {
                    graphNode3 = NDMain.addGraphNode(stateFrame, lambdaNode3);
                    if (lambdaNode3.getRedexes().isEmpty()) {
                        graphNode3.setAccept(true);
                    }
                    if (createdNew) {
                        graphNode3.setLocation(graphNode2.getX(), graphNode2.getY());
                        graphNode3.setDestination(graphNode2.getX(), graphNode2.getY());
                    }
                    linkedList.add(lambdaNode3);
                } else {
                    InfinityNode infinityNode = InfinityNode.getInstance();
                    graphNode3 = NDMain.addGraphNode(stateFrame, infinityNode);
                }
                stateFrame.addEdge(graphNode2, graphNode3);
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        System.out.println("states = " + states.size());
    }

    private static void outputGraph() {
        HashMap<IStateNode, Integer> hashMap = new HashMap<IStateNode, Integer>();
        int n = 0;
        for (IStateNode object : states) {
            hashMap.put(object, n++);
        }
        System.out.println("digraph {");
        System.out.println("  ratio=1.0");
        System.out.println("  fontsize=4;");
        for (IStateNode iStateNode : states) {
            if (iStateNode.isNormalForm()) {
                System.out.printf("  %d [label=\"%s\",peripheries=2];\r\n", hashMap.get(iStateNode), iStateNode.getText());
                continue;
            }
            System.out.printf("  %d [label=\"%s\"];\r\n", hashMap.get(iStateNode), iStateNode.getText());
        }
        for (Map.Entry entry : edges.entrySet()) {
            LambdaNode lambdaNode = (LambdaNode)entry.getKey();
            System.out.printf("  %d->{", hashMap.get(lambdaNode));
            for (IStateNode iStateNode : (Set)entry.getValue()) {
                System.out.printf(" %d", hashMap.get(iStateNode));
            }
            System.out.println(" };");
        }
        System.out.println("}");
    }

    private static void outputGraphFrame() {
        Object object;
        StateFrame stateFrame = new StateFrame();
        stateFrame.setDefaultCloseOperation(3);
        HashMap<IStateNode, Object> hashMap = new HashMap<IStateNode, Object>();
        for (IStateNode object2 : states) {
            object = new GraphNode(object2.getText());
            stateFrame.addNode((GraphNode)object);
            hashMap.put(object2, object);
            if (!object2.isNormalForm()) continue;
            ((GraphNode)object).setAccept(true);
        }
        for (Map.Entry entry : edges.entrySet()) {
            object = (LambdaNode)entry.getKey();
            GraphNode[] graphNodeArray = new GraphNode[((Set)entry.getValue()).size()];
            int n = 0;
            for (IStateNode iStateNode : (Set)entry.getValue()) {
                graphNodeArray[n++] = (GraphNode)hashMap.get(iStateNode);
            }
            stateFrame.addEdge((GraphNode)hashMap.get(object), graphNodeArray);
        }
        stateFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        System.out.println("ND mode");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    Lambda lambda = Lambda.parse(string);
                    NDMain.searchOnLine(lambda, 10);
                }
                catch (ParserException parserException) {
                    parserException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

