/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lambda.Environment;
import lambda.LaTeXStringBuilder;
import lambda.LambdaNode;
import lambda.Reducer;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.RedexFinder;
import lambda.ast.parser.ParserException;
import lambda.gui.GraphNode;
import lambda.gui.StateFrame;

public class NDMain {
    private static LambdaNode NODE_INF;
    private static Set<LambdaNode> states;
    private static Map<LambdaNode, Set<LambdaNode>> edges;

    private static void addEdge(LambdaNode lambdaNode, LambdaNode lambdaNode2) {
        Set<LambdaNode> set = edges.get(lambdaNode);
        if (set == null) {
            set = new HashSet<LambdaNode>();
            edges.put(lambdaNode, set);
        }
        set.add(lambdaNode2);
    }

    private static void search(Lambda lambda, int n) {
        Environment environment = Environment.getEnvironment();
        LinkedList<LambdaNode> linkedList = new LinkedList<LambdaNode>();
        linkedList.add(new LambdaNode(0, lambda));
        while (!linkedList.isEmpty()) {
            LambdaNode lambdaNode = (LambdaNode)linkedList.poll();
            Lambda lambda2 = lambdaNode.lambda;
            if (states.contains(lambdaNode)) continue;
            states.add(lambdaNode);
            List<IRedex> list = RedexFinder.getRedexList(lambda2);
            if (list.isEmpty()) {
                lambdaNode.normal = true;
                continue;
            }
            for (IRedex iRedex : list) {
                Reducer.Result result = Reducer.reduce(lambda2, environment, iRedex);
                LambdaNode lambdaNode2 = new LambdaNode(lambdaNode.depth + 1, result.lambda);
                if (lambdaNode.depth + 1 <= n || states.contains(lambdaNode2)) {
                    NDMain.addEdge(lambdaNode, lambdaNode2);
                    linkedList.add(lambdaNode2);
                    continue;
                }
                if (NODE_INF == null) {
                    NODE_INF = new LambdaNode(0, null);
                    states.add(NODE_INF);
                }
                NDMain.addEdge(lambdaNode, NODE_INF);
                System.out.println("limit");
            }
        }
        System.out.println("states = " + states.size());
    }

    private static void outputGraph() {
        Object object;
        HashMap<LambdaNode, Integer> hashMap = new HashMap<LambdaNode, Integer>();
        int n = 0;
        for (LambdaNode object2 : states) {
            hashMap.put(object2, n++);
        }
        System.out.println("digraph {");
        System.out.println("  ratio=1.0");
        System.out.println("  fontsize=4;");
        for (LambdaNode lambdaNode : states) {
            object = lambdaNode != NODE_INF ? lambdaNode.lambda.toString().replace("\\", "\u03bb") : "\u221e";
            if (lambdaNode.normal) {
                System.out.printf("  %d [label=\"%s\",peripheries=2];\r\n", hashMap.get(lambdaNode), object);
                continue;
            }
            System.out.printf("  %d [label=\"%s\"];\r\n", hashMap.get(lambdaNode), object);
        }
        for (Map.Entry entry : edges.entrySet()) {
            object = (LambdaNode)entry.getKey();
            if (object == NODE_INF) continue;
            System.out.printf("  %d->{", hashMap.get(object));
            for (LambdaNode lambdaNode : (Set)entry.getValue()) {
                System.out.printf(" %d", hashMap.get(lambdaNode));
            }
            System.out.println(" };");
        }
        System.out.println("}");
    }

    private static void outputGraphFrame() {
        GraphNode[] graphNodeArray;
        Object object;
        StateFrame stateFrame = new StateFrame();
        stateFrame.setDefaultCloseOperation(3);
        HashMap<LambdaNode, GraphNode[]> hashMap = new HashMap<LambdaNode, GraphNode[]>();
        for (LambdaNode object2 : states) {
            object = object2 != NODE_INF ? object2.lambda.toString().replace("\\", "\u03bb") : "\u221e";
            graphNodeArray = new GraphNode((String)object);
            stateFrame.addNode((GraphNode)graphNodeArray);
            hashMap.put(object2, graphNodeArray);
            if (object2.normal) {
                graphNodeArray.setAccept(true);
            }
            if (object2.depth != 0) continue;
            stateFrame.setInitialNode((GraphNode)graphNodeArray);
        }
        for (Map.Entry entry : edges.entrySet()) {
            object = (LambdaNode)entry.getKey();
            if (object == NODE_INF) continue;
            graphNodeArray = new GraphNode[((Set)entry.getValue()).size()];
            int n = 0;
            for (LambdaNode lambdaNode : (Set)entry.getValue()) {
                graphNodeArray[n++] = (GraphNode)hashMap.get(lambdaNode);
            }
            stateFrame.addEdge((GraphNode)hashMap.get(object), graphNodeArray);
        }
        stateFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        System.out.println("ND mode");
        LaTeXStringBuilder laTeXStringBuilder = new LaTeXStringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    Lambda lambda = Lambda.parse(string);
                    System.out.println(laTeXStringBuilder.build(lambda));
                }
                catch (ParserException parserException) {
                    parserException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        states = new HashSet<LambdaNode>();
        edges = new HashMap<LambdaNode, Set<LambdaNode>>();
    }
}

