/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class LambdaMatcher {
    private static MatchingVisitor visitor;

    public static boolean structuralEquivalent(Lambda lambda, Lambda lambda2) {
        if (visitor == null) {
            visitor = new MatchingVisitor();
        }
        return lambda.accept(visitor, lambda2);
    }

    private static class MatchingVisitor
    implements Lambda.VisitorRP<Boolean, Lambda> {
        private MatchingVisitor() {
        }

        @Override
        public Boolean visit(ASTAbstract aSTAbstract, Lambda lambda) {
            if (lambda.getClass() == ASTAbstract.class) {
                ASTAbstract aSTAbstract2 = (ASTAbstract)lambda;
                return aSTAbstract.e.accept(this, aSTAbstract2.e);
            }
            return false;
        }

        @Override
        public Boolean visit(ASTApply aSTApply, Lambda lambda) {
            if (lambda.getClass() == ASTApply.class) {
                ASTApply aSTApply2 = (ASTApply)lambda;
                return aSTApply.lexpr.accept(this, aSTApply2.lexpr) != false && aSTApply.rexpr.accept(this, aSTApply2.rexpr) != false;
            }
            return false;
        }

        @Override
        public Boolean visit(ASTLiteral aSTLiteral, Lambda lambda) {
            return lambda.getClass() == ASTLiteral.class;
        }

        @Override
        public Boolean visit(ASTMacro aSTMacro, Lambda lambda) {
            if (lambda.getClass() == ASTMacro.class) {
                ASTMacro aSTMacro2 = (ASTMacro)lambda;
                return aSTMacro.name.equals(aSTMacro2.name);
            }
            return false;
        }
    }
}

