/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lambda.AlphaComparator;
import lambda.Environment;
import lambda.Reducer;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.RedexFinder;

public class LambdaInterpreter {
    private LinkedList<Lambda> steps = new LinkedList();
    private Lambda sourceLambda;
    private Lambda lambda;
    private boolean isCyclic;

    public LambdaInterpreter(Lambda lambda) {
        this.sourceLambda = lambda;
        this.initialize();
    }

    public void initialize() {
        this.lambda = this.sourceLambda;
        this.isCyclic = false;
        this.steps.clear();
        this.push();
    }

    public boolean step(Environment environment) {
        return this.step(environment, null);
    }

    public boolean step(Environment environment, IRedex iRedex) {
        if (!this.isCyclic) {
            Reducer.Result result = Reducer.reduce(this.lambda, environment, iRedex);
            this.isCyclic = AlphaComparator.alphaEquiv(this.lambda, result.lambda);
            this.lambda = result.lambda;
            this.push();
            return result.reduced;
        }
        return false;
    }

    public void revert() {
        this.pop();
    }

    public boolean isRevertable() {
        return !this.steps.isEmpty();
    }

    public int getStep() {
        return this.steps.size() - 1;
    }

    public boolean isNormal() {
        boolean bl = Environment.getEnvironment().getBoolean("eta_reduction");
        return RedexFinder.isNormalForm(this.lambda, bl);
    }

    public boolean isCyclic() {
        return !this.isNormal() && this.isCyclic;
    }

    public boolean isTerminated() {
        return this.isNormal() || this.isCyclic();
    }

    public Lambda getLambda() {
        return this.lambda;
    }

    public List<Lambda> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    private void push() {
        this.steps.push(this.lambda);
    }

    private void pop() {
        if (!this.steps.isEmpty()) {
            this.lambda = this.steps.pop();
        }
    }
}

