/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class LaTeXStringBuilder {
    private static VisitorImpl visitor = new VisitorImpl();

    public String build(Lambda lambda) {
        return lambda.accept(visitor);
    }

    private static class VisitorImpl
    implements Lambda.VisitorR<String> {
        private VisitorImpl() {
        }

        @Override
        public String visit(ASTAbstract aSTAbstract) {
            String string = "\\lambda{";
            Lambda lambda = aSTAbstract;
            while (((Lambda)lambda).isAbstraction()) {
                ASTAbstract aSTAbstract2 = lambda;
                string = string + aSTAbstract2.name;
                lambda = aSTAbstract2.e;
            }
            string = string + "}.";
            string = string + ((Lambda)lambda).accept(this);
            return string;
        }

        @Override
        public String visit(ASTApply aSTApply) {
            Lambda lambda = aSTApply.lexpr;
            Lambda lambda2 = aSTApply.rexpr;
            boolean bl = lambda.isAbstraction();
            boolean bl2 = lambda2.isAbstraction() || lambda2.isApplication();
            String string = lambda.accept(this);
            if (bl) {
                string = "(" + string + ")";
            }
            String string2 = lambda2.accept(this);
            if (bl2) {
                string2 = "(" + string2 + ")";
            }
            return string + "\\," + string2;
        }

        @Override
        public String visit(ASTLiteral aSTLiteral) {
            return aSTLiteral.name;
        }

        @Override
        public String visit(ASTMacro aSTMacro) {
            return "\\overline{\\rm\\bf\\strut " + aSTMacro.name + "}";
        }
    }
}

