/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.QuadCurve2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import lambda.gui.GraphNode;

class GraphPanel
extends JPanel {
    private GraphNode initialNode;
    private Set<GraphNode> nodes = new HashSet<GraphNode>();
    private Map<GraphNode, Set<GraphNode>> edges = new HashMap<GraphNode, Set<GraphNode>>();

    private void createSample() {
        GraphNode[] graphNodeArray = new GraphNode[13];
        for (int i = 0; i < graphNodeArray.length; ++i) {
            graphNodeArray[i] = new GraphNode("Node " + i);
        }
        this.addEdge(graphNodeArray[0], graphNodeArray[10], graphNodeArray[9]);
        this.addEdge(graphNodeArray[2], graphNodeArray[12]);
        this.addEdge(graphNodeArray[1], graphNodeArray[12]);
        this.addEdge(graphNodeArray[11], graphNodeArray[0]);
        this.addEdge(graphNodeArray[5], graphNodeArray[6]);
        this.addEdge(graphNodeArray[4], graphNodeArray[8], graphNodeArray[7]);
        this.addEdge(graphNodeArray[3], graphNodeArray[7], graphNodeArray[6]);
        this.addEdge(graphNodeArray[8], graphNodeArray[2]);
        this.addEdge(graphNodeArray[7], graphNodeArray[2], graphNodeArray[1]);
        this.addEdge(graphNodeArray[6], graphNodeArray[1]);
        this.addEdge(graphNodeArray[10], graphNodeArray[5], graphNodeArray[3]);
        this.addEdge(graphNodeArray[9], graphNodeArray[4], graphNodeArray[3]);
        this.nodes.addAll(Arrays.asList(graphNodeArray));
        this.initialNode = graphNodeArray[11];
        graphNodeArray[12].setAccept(true);
    }

    public void addNode(GraphNode graphNode) {
        this.nodes.add(graphNode);
    }

    public void setInitialNode(GraphNode graphNode) {
        this.initialNode = graphNode;
    }

    public void addEdge(GraphNode graphNode, GraphNode graphNode2) {
        Set<GraphNode> set = this.edges.get(graphNode);
        if (set == null) {
            set = new HashSet<GraphNode>();
            this.edges.put(graphNode, set);
        }
        set.add(graphNode2);
    }

    public void addEdge(GraphNode graphNode, GraphNode ... graphNodeArray) {
        for (GraphNode graphNode2 : graphNodeArray) {
            this.addEdge(graphNode, graphNode2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void layoutNodes() {
        HashMap hashMap = new HashMap();
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<GraphNode> linkedList = new LinkedList<GraphNode>();
        this.initialNode.setDepth(0);
        linkedList.add(this.initialNode);
        int n = 0;
        while (!linkedList.isEmpty()) {
            void hashSet2;
            GraphNode graphNode = (GraphNode)linkedList.poll();
            hashSet.add(graphNode);
            n = Math.max(graphNode.getDepth(), n);
            Set set = (Set)hashMap.get(graphNode.getDepth());
            if (set == null) {
                HashSet hashSet3 = new HashSet();
                hashMap.put(graphNode.getDepth(), hashSet3);
            }
            hashSet2.add(graphNode);
            if (!this.edges.containsKey(graphNode)) continue;
            for (GraphNode graphNode2 : this.edges.get(graphNode)) {
                if (hashSet.contains(graphNode2)) continue;
                graphNode2.setDepth(graphNode.getDepth() + 1);
                linkedList.add(graphNode2);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Set set = (Set)entry.getValue();
            int n2 = set.size();
            int n3 = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                GraphNode graphNode = (GraphNode)iterator.next();
                graphNode.setX(this.getWidth() * (graphNode.getDepth() + 1) / (n + 2));
                graphNode.setY(this.getHeight() * ++n3 / (n2 + 1));
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.layoutNodes();
        for (Map.Entry<GraphNode, Set<GraphNode>> object : this.edges.entrySet()) {
            GraphNode graphNode = object.getKey();
            for (GraphNode graphNode2 : object.getValue()) {
                this.drawCurveEdge((Graphics2D)graphics, graphNode.getX(), graphNode.getY(), graphNode2.getX(), graphNode2.getY());
            }
        }
        for (GraphNode graphNode : this.nodes) {
            graphNode.draw(graphics);
        }
    }

    private void drawCurveEdge(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.DARK_GRAY);
        double d = Math.atan2(n4 - n2, n3 - n) - 1.5707963267948966;
        int n5 = (n + n3) / 2;
        int n6 = (n2 + n4) / 2;
        int n7 = 50;
        double d2 = (double)(n + n3) / 2.0 + (double)n7 * Math.cos(d);
        double d3 = (double)(n2 + n4) / 2.0 + (double)n7 * Math.sin(d);
        double d4 = Math.atan2(d3 - (double)n2, d2 - (double)n);
        double d5 = Math.atan2((double)n4 - d3, (double)n3 - d2);
        double d6 = 10.0;
        double d7 = (double)n + d6 * Math.cos(d4);
        double d8 = (double)n2 + d6 * Math.sin(d4);
        double d9 = (double)n3 - d6 * Math.cos(d5);
        double d10 = (double)n4 - d6 * Math.sin(d5);
        QuadCurve2D.Double double_ = new QuadCurve2D.Double(d7, d8, d2, d3, d9, d10);
        graphics2D.draw(double_);
        this.drawTriangle(graphics2D, d9, d10, d5);
    }

    private void drawStraightEdge(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setColor(Color.DARK_GRAY);
        double d = Math.atan2(n4 - n2, n3 - n);
        double d2 = 10.0;
        double d3 = (double)n + d2 * Math.cos(d);
        double d4 = (double)n2 + d2 * Math.sin(d);
        double d5 = (double)n3 - d2 * Math.cos(d);
        double d6 = (double)n4 - d2 * Math.sin(d);
        graphics2D.drawLine((int)d3, (int)d4, (int)d5, (int)d6);
        this.drawTriangle(graphics2D, d5, d6, d);
    }

    private void drawTriangle(Graphics graphics, double d, double d2, double d3) {
        int n = 10;
        Polygon polygon = new Polygon();
        polygon.addPoint((int)d, (int)d2);
        polygon.addPoint((int)(d - (double)n * Math.cos(d3 + 0.5235987755982988)), (int)(d2 - (double)n * Math.sin(d3 + 0.5235987755982988)));
        polygon.addPoint((int)(d - (double)n * Math.cos(d3 - 0.5235987755982988)), (int)(d2 - (double)n * Math.sin(d3 - 0.5235987755982988)));
        graphics.fillPolygon(polygon);
    }
}

