/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.fontdialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lambda.gui.fontdialog.event.FontUpdateListener;

public class FontDialog
extends JDialog {
    private String initSelectedName;
    private JComboBox familyNames;
    private JSpinner fontSize;
    private JLabel labelFontAddition;
    private int fontAddition;
    private boolean approved;
    private List<FontUpdateListener> fontApplyListeners = new ArrayList<FontUpdateListener>();

    public FontDialog() {
        this.setTitle("Font Setting");
        this.setDefaultCloseOperation(2);
        this.familyNames = new JComboBox();
        Dimension dimension = this.familyNames.getPreferredSize();
        dimension.width = 160;
        this.familyNames.setPreferredSize(dimension);
        this.familyNames.setMaximumSize(dimension);
        this.familyNames.setMinimumSize(dimension);
        this.familyNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.dispatchFontFamilyChangeEvent();
            }
        });
        this.add(this.familyNames);
        SwingWorker<String[], Void> swingWorker = new SwingWorker<String[], Void>(){

            @Override
            protected void done() {
                try {
                    for (String string : (String[])this.get()) {
                        FontDialog.this.familyNames.addItem(string);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                }
                FontDialog.this.familyNames.setSelectedItem(FontDialog.this.initSelectedName);
            }

            @Override
            protected String[] doInBackground() throws Exception {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                return graphicsEnvironment.getAvailableFontFamilyNames();
            }
        };
        swingWorker.execute();
        this.fontSize = new JSpinner(new SpinnerNumberModel(12, 5, 120, 1));
        this.fontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FontDialog.this.dispatchFontSizeChangeEvent();
            }
        });
        this.add(this.fontSize);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("UI Font Size"));
        this.labelFontAddition = new JLabel("+0");
        jPanel.add(this.labelFontAddition);
        JButton jButton = new JButton("+");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.setFontAddition(FontDialog.this.getFontAddition() + 1);
                FontDialog.this.dispatchUIFontAdditionChangeEvent();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("-");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.setFontAddition(FontDialog.this.getFontAddition() - 1);
                FontDialog.this.dispatchUIFontAdditionChangeEvent();
            }
        });
        jPanel.add(jButton2);
        this.add(jPanel);
        JButton jButton3 = new JButton("OK");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.approved = true;
                FontDialog.this.dispose();
            }
        });
        this.add(jButton3);
        JButton jButton4 = new JButton("Cancel");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.dispose();
            }
        });
        this.add(jButton4);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(this.familyNames).addComponent(this.fontSize)).addComponent(jPanel)).addGroup(groupLayout.createSequentialGroup().addComponent(jButton3).addComponent(jButton4)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.familyNames).addComponent(this.fontSize)).addComponent(jPanel).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jButton3).addComponent(jButton4)));
        groupLayout.linkSize(jButton3, jButton4);
        this.pack();
    }

    public void setSelectedFont(Font font) {
        String string = font.getFamily();
        int n = font.getSize();
        this.familyNames.setSelectedItem(string);
        this.fontSize.setValue(n);
    }

    public void setSelectedFamilyName(String string) {
        this.initSelectedName = string;
        this.familyNames.setSelectedItem(string);
    }

    public void setSelectedFontSize(int n) {
        this.fontSize.setValue(n);
    }

    public void setFontAddition(int n) {
        this.fontAddition = n;
        this.labelFontAddition.setText(String.format("%+d", this.fontAddition));
    }

    public String getSelectedFamilyName() {
        return (String)this.familyNames.getSelectedItem();
    }

    public int getSelectedFontSize() {
        return (Integer)this.fontSize.getValue();
    }

    public int getFontAddition() {
        return this.fontAddition;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public boolean isCanceled() {
        return !this.approved;
    }

    public boolean showModal() {
        this.approved = false;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setVisible(true);
        return this.approved;
    }

    public void addFontApplyListener(FontUpdateListener fontUpdateListener) {
        this.fontApplyListeners.add(fontUpdateListener);
    }

    public void removeFontApplyListener(FontUpdateListener fontUpdateListener) {
        this.fontApplyListeners.remove(fontUpdateListener);
    }

    private void dispatchFontFamilyChangeEvent() {
        for (FontUpdateListener fontUpdateListener : this.fontApplyListeners) {
            fontUpdateListener.fontFamilyChanged(this.getSelectedFamilyName());
        }
    }

    private void dispatchFontSizeChangeEvent() {
        for (FontUpdateListener fontUpdateListener : this.fontApplyListeners) {
            fontUpdateListener.fontSizeChanged(this.getSelectedFontSize());
        }
    }

    private void dispatchUIFontAdditionChangeEvent() {
        for (FontUpdateListener fontUpdateListener : this.fontApplyListeners) {
            fontUpdateListener.uiFontAdditionChanged(this.getFontAddition());
        }
    }
}

