/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import extgui.LineEditor;
import extgui.flatsplitpane.FlatSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import lambda.Environment;
import lambda.LambdaInterpreter;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.MacroExpander;
import lambda.ast.RedexFinder;
import lambda.ast.parser.ParserException;
import lambda.conversion.Converter;
import lambda.gui.MainMenu;
import lambda.gui.RedexView;
import lambda.gui.macroview.MacroDefinitionView;
import lambda.system.CommandDelegate;
import lambda.system.CommandProcessor;
import util.nullable.NullableBool;
import util.nullable.NullableInt;

public class MainFrame
extends JFrame {
    private JTabbedPane tabbedPane;
    private LineEditor inputField;
    private JButton buttonStep;
    private JButton buttonClear;
    private JCheckBox checkPrintStep;
    private JCheckBox checkShort;
    private JCheckBox checkEtaEnabled;
    private JCheckBox checkDataConv;
    private JCheckBox checkAuto;
    private JCheckBox checkTraceInAuto;
    private JButton buttonStop;
    private RedexView redexView;
    private JTextArea output;
    private MacroDefinitionView macroView;
    private Environment env = Environment.getEnvironment();
    private final CommandProcessor commands = new CommandProcessor();
    private LambdaInterpreter interpreter;
    private boolean autoRunning;
    private Thread thread;

    public MainFrame() {
        this.setTitle("Lambda * Magica 3.70");
        this.setJMenuBar(new MainMenu(this));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.inputField = new LineEditor();
        this.inputField.setFont(this.env.getGUIFont());
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MainFrame.this.inputField.getText().trim();
                if (!string.isEmpty()) {
                    MainFrame.this.output.setText("");
                    MainFrame.this.inputField.saveHistory();
                    MainFrame.this.inputField.setText("");
                    MainFrame.this.start(string);
                }
            }
        });
        jPanel2.add((Component)this.inputField, "Center");
        this.buttonStep = new JButton("step");
        this.buttonStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MainFrame.this.inputField.getText().trim();
                if (!string.isEmpty()) {
                    MainFrame.this.output.setText("");
                    MainFrame.this.inputField.saveHistory();
                    MainFrame.this.inputField.setText("");
                    MainFrame.this.start(string);
                } else {
                    MainFrame.this.step();
                }
            }
        });
        jPanel2.add((Component)this.buttonStep, "East");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        this.output = new JTextArea();
        this.output.setEditable(false);
        this.output.setFont(this.env.getGUIFont());
        jPanel.add((Component)new JScrollPane(this.output), "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Auto Mode"));
        this.checkAuto = this.createOptionCheckBox("auto", "auto reduction");
        jPanel4.add(this.checkAuto);
        this.checkTraceInAuto = this.createOptionCheckBox("trace", "show trace in auto mode");
        jPanel4.add(this.checkTraceInAuto);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setBorder(BorderFactory.createTitledBorder("Reduction"));
        this.checkEtaEnabled = this.createOptionCheckBox("eta_reduction", "enable eta-reduction");
        jPanel5.add(this.checkEtaEnabled);
        jPanel3.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setBorder(BorderFactory.createTitledBorder("Printing"));
        this.checkPrintStep = this.createOptionCheckBox("print_step", "print step");
        this.checkShort = this.createOptionCheckBox("short", "short printing");
        this.checkDataConv = this.createOptionCheckBox("data_abstraction", "show nat/bool data");
        jPanel6.add(this.checkPrintStep);
        jPanel6.add(this.checkShort);
        jPanel6.add(this.checkDataConv);
        jPanel3.add(jPanel6);
        this.buttonStop = new JButton("stop");
        this.buttonStop.setEnabled(false);
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.thread != null) {
                    MainFrame.this.autoRunning = false;
                    try {
                        MainFrame.this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    MainFrame.this.println("- STOPPED.");
                    MainFrame.this.buttonStop.setEnabled(false);
                    MainFrame.this.thread = null;
                }
            }
        });
        jPanel3.add(this.buttonStop);
        this.buttonClear = new JButton("clear output");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.output.setText("");
            }
        });
        jPanel3.add(this.buttonClear);
        JButton jButton = new JButton("clear macros");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.clearMacros();
            }
        });
        jPanel3.add(jButton);
        GroupLayout groupLayout = new GroupLayout(jPanel3);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(jPanel4, 0, -1, Short.MAX_VALUE).addComponent(jPanel5, 0, -1, Short.MAX_VALUE).addComponent(jPanel6, 0, -1, Short.MAX_VALUE).addComponent(this.buttonStop, 0, -1, Short.MAX_VALUE).addComponent(this.buttonClear, 0, -1, Short.MAX_VALUE).addComponent(jButton, 0, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(jPanel4).addComponent(jPanel5).addComponent(jPanel6).addComponent(this.buttonStop).addComponent(this.buttonClear).addComponent(jButton));
        jPanel3.setLayout(groupLayout);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("General", jPanel3);
        this.redexView = new RedexView();
        this.redexView.setBackground(Color.WHITE);
        this.redexView.setFont(this.env.getGUIFont());
        this.redexView.setMargin(5, 5, 5, 5);
        this.redexView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.step();
            }
        });
        this.tabbedPane.add("Redex", new JScrollPane(this.redexView));
        this.macroView = new MacroDefinitionView();
        this.macroView.setFont(this.env.getGUIFont());
        this.tabbedPane.addTab("Macros", this.macroView);
        final FlatSplitPane flatSplitPane = new FlatSplitPane();
        flatSplitPane.setContinuousLayout(true);
        flatSplitPane.setLeftComponent(jPanel);
        flatSplitPane.setRightComponent(this.tabbedPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                flatSplitPane.setDividerLocation(0.7);
                flatSplitPane.setResizeWeight(0.5);
            }
        });
        flatSplitPane.setDividerLocation(Short.MAX_VALUE);
        this.add(flatSplitPane);
        this.setSize(700, 500);
        this.setupAcceleration();
        this.initializeCommands();
    }

    private void setupAcceleration() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        String string = "font.size.increase";
        String string2 = "font.size.decrease";
        String string3 = "font.size.default";
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(521, n), string);
        inputMap.put(KeyStroke.getKeyStroke(107, n), string);
        inputMap.put(KeyStroke.getKeyStroke(59, n), string);
        inputMap.put(KeyStroke.getKeyStroke(45, n), string2);
        inputMap.put(KeyStroke.getKeyStroke(109, n), string2);
        inputMap.put(KeyStroke.getKeyStroke(48, n), string3);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Environment environment = Environment.getEnvironment();
                int n = environment.getInt("gui.fontsize", 12);
                if (n < 120) {
                    environment.set("gui.fontsize", n + 1);
                    MainFrame.this.setCodeFont(environment.getGUIFont());
                }
            }
        });
        actionMap.put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Environment environment = Environment.getEnvironment();
                int n = environment.getInt("gui.fontsize", 12);
                if (5 < n) {
                    environment.set("gui.fontsize", n - 1);
                    MainFrame.this.setCodeFont(environment.getGUIFont());
                }
            }
        });
        actionMap.put(string3, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Environment environment = Environment.getEnvironment();
                environment.set("gui.fontsize", 12);
                MainFrame.this.setCodeFont(environment.getGUIFont());
            }
        });
    }

    private JCheckBox createOptionCheckBox(final String string, String string2) {
        final JCheckBox jCheckBox = new JCheckBox(string2);
        jCheckBox.setSelected(this.env.getBoolean(string));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.env.set(string, jCheckBox.isSelected());
            }
        });
        return jCheckBox;
    }

    public void setCodeFont(Font font) {
        this.inputField.setFont(font);
        this.output.setFont(font);
        this.redexView.setFont(font);
        this.macroView.setFont(font.deriveFont(0, 12.0f));
    }

    private void start(String string) {
        if (this.autoRunning) {
            return;
        }
        if ((string = string.trim()).startsWith(":")) {
            if (string.startsWith(":q")) {
                this.dispose();
            } else {
                this.commands.invokeCommand(string);
            }
        } else if (!string.isEmpty()) {
            try {
                this.evalLine(string);
            }
            catch (ParserException parserException) {
                String string2 = "";
                for (int i = 0; i < parserException.column; ++i) {
                    string2 = string2 + ' ';
                }
                this.println(string);
                this.println(string2 + '^');
                this.println("- " + parserException.getMessage());
            }
        }
    }

    private boolean stepReduction() {
        boolean bl = this.env.getBoolean("eta_reduction");
        IRedex iRedex = this.redexView.getSelectedRedex();
        if (iRedex == null) {
            iRedex = RedexFinder.getLeftMostOuterMostRedex(this.interpreter.getLambda(), bl);
        }
        return this.interpreter.step(this.env, iRedex);
    }

    private boolean step() {
        if (this.interpreter == null) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = this.stepReduction();
        Lambda lambda = this.interpreter.getLambda();
        if (bl2) {
            if (!this.autoRunning || this.env.getBoolean("trace")) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("--> ");
                if (this.env.getBoolean("print_step")) {
                    stringBuilder.append(String.format("%3d: ", this.interpreter.getStep()));
                }
                String string = lambda.toString();
                if (this.env.getBoolean("short") && string.length() > 75) {
                    stringBuilder.append(string.substring(0, 35));
                    stringBuilder.append(" ... ");
                    stringBuilder.append(string.substring(string.length() - 35, string.length()));
                } else {
                    stringBuilder.append(string);
                }
                this.println(stringBuilder.toString());
            }
            if (this.checkIfCycled() || this.checkIfNormalForm()) {
                this.reductionTerminated();
                bl = false;
            }
        } else {
            this.reductionTerminated();
            bl = false;
        }
        if (!this.autoRunning) {
            this.updateRedexView(lambda);
        }
        return bl;
    }

    private void showConvertedData(Lambda lambda) {
        NullableBool nullableBool;
        NullableInt nullableInt = Converter.toNat(lambda);
        if (nullableInt.hasValue()) {
            this.println("  = " + nullableInt + " (as nat)");
        }
        if ((nullableBool = Converter.toBool(lambda)).hasValue()) {
            this.println("  = " + nullableBool + " (as bool)");
        }
    }

    private boolean checkIfNormalForm() {
        boolean bl;
        Lambda lambda = this.interpreter.getLambda();
        if (RedexFinder.isNormalForm(lambda, bl = this.env.getBoolean("eta_reduction"))) {
            this.printEndState(lambda, "(normal form)");
            return true;
        }
        return false;
    }

    private boolean checkIfCycled() {
        if (this.interpreter.isCyclic()) {
            this.printEndState(this.interpreter.getLambda(), "(cyclic reduction)");
            return true;
        }
        return false;
    }

    private void printEndState(Lambda lambda, String string) {
        MacroExpander macroExpander = new MacroExpander(this.env);
        lambda = macroExpander.expand(lambda, true);
        this.println("==> " + lambda + "    " + string);
        if (this.env.getBoolean("data_abstraction")) {
            this.showConvertedData(lambda);
        }
    }

    private void reductionTerminated() {
        this.buttonStop.setEnabled(false);
        this.interpreter = null;
    }

    private void updateRedexView(Lambda lambda) {
        this.redexView.setRedexes(lambda);
        this.redexView.revalidate();
        this.redexView.repaint();
    }

    private void defineMacro(String string, String string2) {
        try {
            Lambda lambda = Lambda.parse(string2);
            this.env.defineMacro(string, lambda);
            this.macroView.addMacro(string, lambda);
            String string3 = String.format("- <%s> is defined as %s", string, lambda);
            this.println(string3);
        }
        catch (ParserException parserException) {
            this.println("- " + parserException.getMessage());
        }
    }

    private void readMacro(String string) {
        if (string.indexOf(61) != -1) {
            String[] stringArray = string.split("\\s*=\\s*");
            if (stringArray.length == 2) {
                this.defineMacro(stringArray[0], stringArray[1]);
            } else {
                this.println("- Invalid expression: " + string);
            }
        }
    }

    private void evalLine(String string) throws ParserException {
        if (string.indexOf(61) != -1) {
            this.readMacro(string);
        } else {
            Lambda lambda = Lambda.parse(string);
            this.println(lambda.toString());
            this.interpreter = new LambdaInterpreter(lambda);
            if (this.checkIfNormalForm()) {
                this.reductionTerminated();
            } else if (!this.env.getBoolean("auto")) {
                this.tabbedPane.setSelectedIndex(1);
                this.buttonStep.requestFocus();
                this.updateRedexView(lambda);
            } else {
                this.startAuto();
            }
        }
    }

    private void startAuto() {
        this.autoRunning = true;
        this.buttonStop.setEnabled(true);
        this.thread = new AutoRunningThread();
        this.thread.start();
    }

    private void loadFile(String string) {
        if (!string.endsWith(".lm.txt")) {
            string = string + ".lm.txt";
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            this.println("- load '" + string + "'");
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(35);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((string2 = string2.trim()).isEmpty()) continue;
                this.readMacro(string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.println("- cannot open file \"" + string + "\"");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void clearMacros() {
        this.env.clearMacros();
        this.macroView.clearList();
        this.println("- macros were cleared.");
    }

    private void initializeCommands() {
        this.commands.add(":l", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length == 0) {
                    File file = new File(".");
                    for (File file2 : file.listFiles()) {
                        if (!file2.isFile() || !file2.getName().endsWith(".lm.txt")) continue;
                        MainFrame.this.loadFile(file2.getName());
                    }
                } else {
                    for (String string : stringArray) {
                        MainFrame.this.loadFile(string);
                    }
                }
            }
        });
        this.commands.add(":f", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length >= 1) {
                    String string = "";
                    for (String string2 : stringArray) {
                        string = string + string2 + " ";
                    }
                    try {
                        Lambda parserException = Lambda.parse(string);
                        MacroExpander macroExpander = new MacroExpander(MainFrame.this.env);
                        MainFrame.this.println(macroExpander.expand(parserException, true).toString());
                    }
                    catch (ParserException parserException) {
                        MainFrame.this.println(parserException.getMessage());
                    }
                }
            }
        });
        this.commands.add(":c", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.clearMacros();
            }
        });
        this.commands.add(":pwd", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.println(new File("").getAbsolutePath());
            }
        });
        this.commands.add(":?", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.println("- :?         - show this help.");
                MainFrame.this.println("- :f <expr>  - expand macros and show expression.");
                MainFrame.this.println("- :l <path>  - load lines from a text file.");
                MainFrame.this.println("- :s <n>     - set the number of continuation steps.");
                MainFrame.this.println("- :t [on]    - set trace mode. ");
                MainFrame.this.println("- :c         - clear all macros.");
                MainFrame.this.println("- :pwd       - print working directory.");
                MainFrame.this.println("- :q         - quit interpreter.");
            }
        });
    }

    private synchronized void println(String string) {
        this.output.append(string);
        this.output.append(System.getProperty("line.separator"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.output.setCaretPosition(MainFrame.this.output.getText().length());
            }
        });
    }

    private class AutoRunningThread
    extends Thread {
        public AutoRunningThread() {
            this.setName("AutoRunningThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (MainFrame.this.autoRunning && MainFrame.this.step()) {
                }
            }
            catch (StackOverflowError stackOverflowError) {
                MainFrame.this.println("Fatal Error: generated too large structure");
            }
            finally {
                MainFrame.this.buttonStop.setEnabled(false);
                MainFrame.this.autoRunning = false;
                MainFrame.this.thread = null;
            }
        }
    }
}

