/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast.parser;

import lambda.ast.parser.LexerException;
import lambda.ast.parser.Token;
import lambda.ast.parser.TokenType;

public class Lexer {
    private char[] cs;
    private int column;

    public Lexer(String string) {
        this.cs = string.toCharArray();
        this.column = 0;
    }

    public Token nextToken() throws LexerException {
        this.skipWhitespaces();
        if (this.isEnd()) {
            return new Token("$END", TokenType.END, this.column);
        }
        char c = this.peek();
        if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
            int n = this.column;
            this.succ();
            return new Token(Character.toString(c), TokenType.ID, n);
        }
        if (c == '<') {
            int n = this.column;
            this.succ();
            c = this.peek();
            StringBuilder stringBuilder = new StringBuilder();
            while (!this.isEnd() && c != '>') {
                stringBuilder.append(c);
                this.succ();
                c = this.peek();
            }
            if (c == '>') {
                this.succ();
                return new Token(stringBuilder.toString(), TokenType.MACRONAME, n);
            }
            throw new LexerException("Missing '>'.", this.column);
        }
        int n = this.column;
        this.succ();
        switch (c) {
            case '\\': {
                return new Token("\\", TokenType.LAMBDA, n);
            }
            case '.': {
                return new Token(".", TokenType.DOT, n);
            }
            case '(': {
                return new Token("(", TokenType.LPAR, n);
            }
            case ')': {
                return new Token(")", TokenType.RPAR, n);
            }
        }
        throw new LexerException("Illegal character '" + c + "'.", n);
    }

    public boolean isEnd() {
        return this.column >= this.cs.length;
    }

    private void skipWhitespaces() {
        while (!this.isEnd() && Character.isWhitespace(this.peek())) {
            this.succ();
        }
    }

    private char peek() {
        return this.column < this.cs.length ? this.cs[this.column] : (char)'$';
    }

    private void succ() {
        ++this.column;
    }
}

