/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import util.Pair;

class RenameGenerator
implements Lambda.VisitorRP<Lambda, Pair<Set<String>, Map<String, String>>> {
    private Set<String> renameTarget;

    public RenameGenerator(Set<String> set) {
        this.renameTarget = set;
    }

    public Lambda rename(Set<String> set, Lambda lambda) {
        return lambda.accept(this, new Pair(new HashSet<String>(set), new HashMap()));
    }

    @Override
    public Lambda visit(ASTAbstract aSTAbstract, Pair<Set<String>, Map<String, String>> pair) {
        Set set = (Set)pair._1;
        Map map = (Map)pair._2;
        HashSet<String> hashSet = new HashSet<String>(set);
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        if (this.renameTarget.contains(aSTAbstract.name)) {
            String string = RenameGenerator.generateName(set);
            hashMap.put(aSTAbstract.name, string);
            hashSet.add(string);
            Lambda lambda = aSTAbstract.e.accept(this, Pair.of(hashSet, hashMap));
            return new ASTAbstract(aSTAbstract.originalName, string, lambda);
        }
        hashSet.add(aSTAbstract.name);
        Lambda lambda = aSTAbstract.e.accept(this, Pair.of(hashSet, hashMap));
        return lambda == aSTAbstract.e ? aSTAbstract : new ASTAbstract(aSTAbstract.originalName, aSTAbstract.name, lambda);
    }

    @Override
    public Lambda visit(ASTApply aSTApply, Pair<Set<String>, Map<String, String>> pair) {
        Lambda lambda = aSTApply.lexpr.accept(this, pair);
        Lambda lambda2 = aSTApply.rexpr.accept(this, pair);
        return lambda == aSTApply.lexpr && lambda2 == aSTApply.rexpr ? aSTApply : new ASTApply(lambda, lambda2);
    }

    @Override
    public Lambda visit(ASTLiteral aSTLiteral, Pair<Set<String>, Map<String, String>> pair) {
        if (((Map)pair._2).containsKey(aSTLiteral.name)) {
            return new ASTLiteral(aSTLiteral.originalName, (String)((Map)pair._2).get(aSTLiteral.name));
        }
        return aSTLiteral;
    }

    @Override
    public Lambda visit(ASTMacro aSTMacro, Pair<Set<String>, Map<String, String>> pair) {
        return aSTMacro;
    }

    private static String generateName(Set<String> set) {
        String string;
        int n;
        for (n = 97; n <= 122; n = (char)(n + '\u0001')) {
            string = Character.toString((char)n);
            if (set.contains(string)) continue;
            return string;
        }
        for (n = 65; n <= 90; n = (char)(n + '\u0001')) {
            string = Character.toString((char)n);
            if (set.contains(string)) continue;
            return string;
        }
        for (n = 0; n < 1000000; ++n) {
            string = "$" + n;
            if (set.contains(string)) continue;
            return string;
        }
        throw new RuntimeException("failed to generate name");
    }
}

