/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.VariableCollector;

public class RedexFinder {
    private static VisitorImpl visitor;
    private static LOVisitor loVisitor;

    public static IRedex getLeftMostOuterMostRedex(Lambda lambda, boolean bl) {
        if (loVisitor == null) {
            loVisitor = new LOVisitor();
        }
        loVisitor.etaEnabled = bl;
        return lambda.accept(loVisitor);
    }

    public static boolean isNormalForm(Lambda lambda, boolean bl) {
        return RedexFinder.getLeftMostOuterMostRedex(lambda, bl) == null;
    }

    public static List<IRedex> getRedexList(Lambda lambda) {
        return RedexFinder.getRedexList(lambda, false);
    }

    public static List<IRedex> getRedexList(Lambda lambda, boolean bl) {
        if (visitor == null) {
            visitor = new VisitorImpl();
        }
        visitor.etaEnabled = bl;
        ArrayList<IRedex> arrayList = new ArrayList<IRedex>();
        lambda.accept(visitor, arrayList);
        return arrayList;
    }

    private static boolean isBetaRedex(ASTApply aSTApply) {
        return aSTApply.lexpr.isAbstraction();
    }

    private static boolean isEtaRedex(ASTAbstract aSTAbstract) {
        if (aSTAbstract.e.isApplication()) {
            ASTApply aSTApply = (ASTApply)aSTAbstract.e;
            if (aSTApply.rexpr.isLiteral()) {
                ASTLiteral aSTLiteral = (ASTLiteral)aSTApply.rexpr;
                VariableCollector variableCollector = new VariableCollector(aSTApply.lexpr);
                Set<String> set = variableCollector.getFreeVariables();
                if (!set.contains(aSTLiteral.name)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static class LOVisitor
    implements Lambda.VisitorR<IRedex> {
        private boolean etaEnabled;

        private LOVisitor() {
        }

        @Override
        public IRedex visit(ASTAbstract aSTAbstract) {
            if (this.etaEnabled && RedexFinder.isEtaRedex(aSTAbstract)) {
                return aSTAbstract;
            }
            return aSTAbstract.e.accept(this);
        }

        @Override
        public IRedex visit(ASTApply aSTApply) {
            if (RedexFinder.isBetaRedex(aSTApply)) {
                return aSTApply;
            }
            IRedex iRedex = aSTApply.lexpr.accept(this);
            if (iRedex == null) {
                iRedex = aSTApply.rexpr.accept(this);
            }
            return iRedex;
        }

        @Override
        public IRedex visit(ASTLiteral aSTLiteral) {
            return null;
        }

        @Override
        public IRedex visit(ASTMacro aSTMacro) {
            return aSTMacro;
        }
    }

    private static class VisitorImpl
    implements Lambda.VisitorP<List<IRedex>> {
        private boolean etaEnabled;

        private VisitorImpl() {
        }

        @Override
        public void visit(ASTAbstract aSTAbstract, List<IRedex> list) {
            if (this.etaEnabled && RedexFinder.isEtaRedex(aSTAbstract)) {
                list.add(aSTAbstract);
            }
            aSTAbstract.e.accept(this, list);
        }

        @Override
        public void visit(ASTApply aSTApply, List<IRedex> list) {
            if (RedexFinder.isBetaRedex(aSTApply)) {
                list.add(aSTApply);
            }
            aSTApply.lexpr.accept(this, list);
            aSTApply.rexpr.accept(this, list);
        }

        @Override
        public void visit(ASTLiteral aSTLiteral, List<IRedex> list) {
        }

        @Override
        public void visit(ASTMacro aSTMacro, List<IRedex> list) {
            list.add(aSTMacro);
        }
    }
}

