/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import lambda.Environment;
import lambda.LambdaNode;
import lambda.Reducer;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.RedexFinder;
import lambda.ast.parser.ParserException;

public class NDMain {
    private static Set<LambdaNode> states = new HashSet<LambdaNode>();
    private static Map<LambdaNode, Set<LambdaNode>> edges = new HashMap<LambdaNode, Set<LambdaNode>>();

    private static void addEdge(LambdaNode lambdaNode, LambdaNode lambdaNode2) {
        Set<LambdaNode> set = edges.get(lambdaNode);
        if (set == null) {
            set = new HashSet<LambdaNode>();
            edges.put(lambdaNode, set);
        }
        set.add(lambdaNode2);
    }

    private static void search(Lambda lambda, int n) {
        Environment environment = Environment.getEnvironment();
        LinkedList<LambdaNode> linkedList = new LinkedList<LambdaNode>();
        linkedList.add(new LambdaNode(0, lambda));
        while (!linkedList.isEmpty()) {
            LambdaNode lambdaNode = (LambdaNode)linkedList.poll();
            Lambda lambda2 = lambdaNode.lambda;
            if (lambdaNode.depth >= n || states.contains(lambdaNode)) continue;
            states.add(lambdaNode);
            for (IRedex iRedex : RedexFinder.getRedexList(lambda2)) {
                Reducer.Result result = Reducer.reduce(lambda2, environment, iRedex);
                LambdaNode lambdaNode2 = new LambdaNode(lambdaNode.depth + 1, result.lambda);
                NDMain.addEdge(lambdaNode, lambdaNode2);
                linkedList.add(lambdaNode2);
            }
        }
        System.out.println("states = " + states.size());
    }

    private static void outputGraph() {
        Object object;
        HashMap<LambdaNode, Integer> hashMap = new HashMap<LambdaNode, Integer>();
        int n = 0;
        for (LambdaNode object2 : states) {
            hashMap.put(object2, n++);
        }
        System.out.println("digraph {");
        for (LambdaNode lambdaNode : states) {
            object = lambdaNode.lambda.toString().replace("\\", "\u03bb");
            System.out.printf("  %d [label=\"\"];\r\n", hashMap.get(lambdaNode));
        }
        for (Map.Entry entry : edges.entrySet()) {
            object = (LambdaNode)entry.getKey();
            System.out.printf("  %d->{", hashMap.get(object));
            for (LambdaNode lambdaNode : (Set)entry.getValue()) {
                System.out.printf(" %d", hashMap.get(lambdaNode));
            }
            System.out.println(" };");
        }
        System.out.println("}");
    }

    public static void main(String[] stringArray) {
        System.out.println("ND mode");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    Lambda lambda = Lambda.parse(string);
                    System.out.println("input = " + lambda);
                    NDMain.search(lambda, 1000);
                    NDMain.outputGraph();
                }
                catch (ParserException parserException) {
                    parserException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

