/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import lambda.AlphaComparator;
import lambda.Environment;
import lambda.Reducer;
import lambda.ast.IRedex;
import lambda.ast.Lambda;

public class LambdaInterpreter {
    private Lambda sourceLambda;
    private Lambda lambda;
    private boolean isNormal;
    private boolean isCyclic;
    private int stepCount;

    public LambdaInterpreter(Lambda lambda) {
        this.sourceLambda = lambda;
        this.initialize();
    }

    public void initialize() {
        this.lambda = this.sourceLambda;
        this.isNormal = false;
        this.isCyclic = false;
        this.stepCount = 0;
    }

    public boolean step(Environment environment) {
        return this.step(environment, null);
    }

    public boolean step(Environment environment, IRedex iRedex) {
        if (!this.isCyclic) {
            Reducer.Result result = Reducer.reduce(this.lambda, environment, iRedex);
            this.isCyclic = AlphaComparator.alphaEquiv(this.lambda, result.lambda);
            this.lambda = result.lambda;
            if (result.reduced) {
                ++this.stepCount;
            }
            return result.reduced;
        }
        return false;
    }

    public int getStep() {
        return this.stepCount;
    }

    public boolean isNormal() {
        return this.isNormal;
    }

    public boolean isCyclic() {
        return !this.isNormal && this.isCyclic;
    }

    public boolean isTerminated() {
        return this.isNormal() || this.isCyclic();
    }

    public Lambda getLambda() {
        return this.lambda;
    }
}

