/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import lambda.LambdaMatcher;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import lambda.ast.parser.ParserException;

public class AlphaComparator {
    private static AlphaVisitor visitor = new AlphaVisitor();

    public static boolean alphaEquiv(Lambda lambda, Lambda lambda2) {
        visitor.initialize();
        return lambda.accept(visitor, lambda2);
    }

    public static void main(String[] stringArray) {
        System.out.println("AlpahEquivTest");
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.print("input e1> ");
            String string = scanner.nextLine();
            if (string == null || (string = string.trim()).isEmpty()) break;
            System.out.print("input e2> ");
            String string2 = scanner.nextLine();
            if (string2 == null || (string2 = string2.trim()).isEmpty()) break;
            try {
                Lambda lambda = Lambda.parse(string);
                Lambda lambda2 = Lambda.parse(string2);
                System.out.println("e1 = " + lambda);
                System.out.println("e2 = " + lambda2);
                System.out.println("structural equiv: " + LambdaMatcher.structuralEquivalent(lambda, lambda2));
                System.out.println("     alpha equiv: " + AlphaComparator.alphaEquiv(lambda, lambda2));
            }
            catch (ParserException parserException) {
                System.out.println(parserException.getMessage());
            }
        }
    }

    private static class AlphaVisitor
    implements Lambda.VisitorRP<Boolean, Lambda> {
        private Context cl = new Context();
        private Context cr = new Context();
        private Map<String, Integer> fv = new HashMap<String, Integer>();
        private int fvId = 1;

        private AlphaVisitor() {
        }

        public void initialize() {
            this.cl.clear();
            this.cr.clear();
            this.fv.clear();
            this.fvId = 1;
        }

        @Override
        public Boolean visit(ASTAbstract aSTAbstract, Lambda lambda) {
            if (lambda instanceof ASTAbstract) {
                ASTAbstract aSTAbstract2 = (ASTAbstract)lambda;
                this.push(aSTAbstract.name, aSTAbstract2.name);
                boolean bl = aSTAbstract.e.accept(this, aSTAbstract2.e);
                this.pop();
                return bl;
            }
            return false;
        }

        @Override
        public Boolean visit(ASTApply aSTApply, Lambda lambda) {
            if (lambda instanceof ASTApply) {
                ASTApply aSTApply2 = (ASTApply)lambda;
                return aSTApply.lexpr.accept(this, aSTApply2.lexpr) != false && aSTApply.rexpr.accept(this, aSTApply2.rexpr) != false;
            }
            return false;
        }

        @Override
        public Boolean visit(ASTLiteral aSTLiteral, Lambda lambda) {
            if (lambda instanceof ASTLiteral) {
                ASTLiteral aSTLiteral2 = (ASTLiteral)lambda;
                return this.getId(this.cl, aSTLiteral.name) == this.getId(this.cr, aSTLiteral2.name);
            }
            return false;
        }

        @Override
        public Boolean visit(ASTMacro aSTMacro, Lambda lambda) {
            if (lambda instanceof ASTMacro) {
                ASTMacro aSTMacro2 = (ASTMacro)lambda;
                return this.getFreeVariableId(aSTMacro.name) == this.getFreeVariableId(aSTMacro2.name);
            }
            return false;
        }

        private void push(String string, String string2) {
            this.cl.pushVariable(string);
            this.cr.pushVariable(string2);
        }

        private void pop() {
            this.cl.popVariable();
            this.cr.popVariable();
        }

        private int getId(Context context, String string) {
            int n = context.findVariable(string);
            if (n != -1) {
                return n;
            }
            return this.getFreeVariableId(string);
        }

        private int getFreeVariableId(String string) {
            Integer n = this.fv.get(string);
            if (n == null) {
                n = -this.fvId++;
                this.fv.put(string, n);
            }
            return n;
        }

        private static class Context {
            private LinkedList<String> names = new LinkedList();

            private Context() {
            }

            public void clear() {
                this.names.clear();
            }

            public void pushVariable(String string) {
                this.names.push(string);
            }

            public void popVariable() {
                this.names.pop();
            }

            public int findVariable(String string) {
                Iterator iterator = this.names.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    if (((String)iterator.next()).equals(string)) {
                        return n + 1;
                    }
                    ++n;
                }
                return -1;
            }
        }
    }
}

