/*
 * Decompiled with CFR 0.152.
 */
package lambda.serialize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import lambda.ast.parser.ParserException;

public class LambdaSerializer {
    private static SerializeVisitor visitor;

    private LambdaSerializer() {
    }

    public static short[] serialize(Lambda lambda) {
        if (visitor == null) {
            visitor = new SerializeVisitor();
        }
        ArrayList arrayList = new ArrayList();
        visitor.initialize();
        lambda.accept(visitor, arrayList);
        short[] sArray = new short[arrayList.size()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (Short)arrayList.get(i);
        }
        return sArray;
    }

    public static void main(String[] stringArray) {
        System.out.println("SerializeTest");
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.print("input> ");
            String string = scanner.nextLine();
            if (string == null || (string = string.trim()).isEmpty()) break;
            try {
                Lambda lambda = Lambda.parse(string);
                System.out.println("e = " + lambda);
                System.out.println("data: " + Arrays.toString(LambdaSerializer.serialize(lambda)));
            }
            catch (ParserException parserException) {
                System.out.println(parserException.getMessage());
            }
        }
    }

    private static class SerializeVisitor
    implements Lambda.VisitorRP<Object, List<Short>> {
        private static final short LAMBDA_BEGIN = 32766;
        private static final short LAMBDA_END = Short.MAX_VALUE;
        private Context cl = new Context();
        private Map<String, Short> fv = new HashMap<String, Short>();
        private short fvId = 1;

        private SerializeVisitor() {
        }

        public void initialize() {
            this.cl.clear();
            this.fv.clear();
            this.fvId = 1;
        }

        @Override
        public Object visit(ASTAbstract aSTAbstract, List<Short> list) {
            this.cl.pushVariable(aSTAbstract.name);
            list.add((short)32766);
            aSTAbstract.e.accept(this, list);
            list.add((short)Short.MAX_VALUE);
            this.cl.popVariable();
            return null;
        }

        @Override
        public Object visit(ASTApply aSTApply, List<Short> list) {
            aSTApply.lexpr.accept(this, list);
            aSTApply.rexpr.accept(this, list);
            return null;
        }

        @Override
        public Object visit(ASTLiteral aSTLiteral, List<Short> list) {
            list.add(this.getId(this.cl, aSTLiteral.name));
            return null;
        }

        @Override
        public Object visit(ASTMacro aSTMacro, List<Short> list) {
            list.add(this.getFreeVariableId(aSTMacro.name));
            return null;
        }

        private short getId(Context context, String string) {
            short s = context.findVariable(string);
            if (s != -1) {
                return s;
            }
            return this.getFreeVariableId(string);
        }

        private short getFreeVariableId(String string) {
            Short s = this.fv.get(string);
            if (s == null) {
                short s2 = this.fvId;
                this.fvId = (short)(s2 + 1);
                s = -s2;
                this.fv.put(string, s);
            }
            return s;
        }

        private static class Context {
            private LinkedList<String> names = new LinkedList();

            private Context() {
            }

            public void clear() {
                this.names.clear();
            }

            public void pushVariable(String string) {
                this.names.push(string);
            }

            public void popVariable() {
                this.names.pop();
            }

            public short findVariable(String string) {
                Iterator iterator = this.names.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    if (((String)iterator.next()).equals(string)) {
                        return (short)(n + 1);
                    }
                    n = (short)(n + 1);
                }
                return -1;
            }
        }
    }
}

