/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import util.Pair;

public class Substituter {
    private VisitorImpl visitor = new VisitorImpl();
    private int varid;

    public Lambda substitute(Lambda lambda, String string, Lambda lambda2) {
        return this.visitor.visit(lambda, (Pair<String, Lambda>)Pair.of(string, lambda2));
    }

    private class VisitorImpl
    implements Lambda.VisitorRP<Lambda, Pair<String, Lambda>> {
        private VisitorImpl() {
        }

        private Lambda visit(Lambda lambda, Pair<String, Lambda> pair) {
            return lambda.accept(this, pair);
        }

        @Override
        public Lambda visit(ASTAbstract aSTAbstract, Pair<String, Lambda> pair) {
            String string = "$" + Substituter.this.varid++;
            ASTLiteral aSTLiteral = new ASTLiteral(aSTAbstract.originalName, string);
            Lambda lambda = this.visit(aSTAbstract.e, new Pair<String, Lambda>(aSTAbstract.name, aSTLiteral));
            lambda = this.visit(lambda, pair);
            return new ASTAbstract(aSTAbstract.originalName, string, lambda);
        }

        @Override
        public Lambda visit(ASTApply aSTApply, Pair<String, Lambda> pair) {
            Lambda lambda = this.visit(aSTApply.lexpr, pair);
            Lambda lambda2 = this.visit(aSTApply.rexpr, pair);
            return lambda == aSTApply.lexpr && lambda2 == aSTApply.rexpr ? aSTApply : new ASTApply(lambda, lambda2);
        }

        @Override
        public Lambda visit(ASTLiteral aSTLiteral, Pair<String, Lambda> pair) {
            String string = (String)pair._1;
            return string.equals(aSTLiteral.name) ? (Lambda)pair._2 : aSTLiteral;
        }

        @Override
        public Lambda visit(ASTMacro aSTMacro, Pair<String, Lambda> pair) {
            return aSTMacro;
        }
    }
}

