/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.Set;
import lambda.Environment;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IDContext;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.VariableCollector;

public class Reducer {
    private static ReductionVisitor visitor;

    public static Result reduce(Lambda lambda, Environment environment, IRedex iRedex) {
        if (lambda == null || environment == null || iRedex == null) {
            throw new NullPointerException();
        }
        if (visitor == null) {
            visitor = new ReductionVisitor();
        }
        visitor.env = environment;
        visitor.redex = iRedex;
        return Reducer.visitor.reduce(lambda, IDContext.createContext());
    }

    private static class ReductionVisitor
    implements Lambda.VisitorRP<Result, IDContext> {
        private Environment env;
        private IRedex redex;

        private ReductionVisitor() {
        }

        @Override
        public Result visit(ASTAbstract aSTAbstract, IDContext iDContext) {
            Object object;
            Object object2;
            if (this.isRedex(aSTAbstract) && aSTAbstract.e instanceof ASTApply) {
                object2 = (ASTApply)aSTAbstract.e;
                if (((ASTApply)object2).rexpr instanceof ASTLiteral) {
                    object = (ASTLiteral)((ASTApply)object2).rexpr;
                    VariableCollector variableCollector = new VariableCollector(((ASTApply)object2).lexpr);
                    Set<String> set = variableCollector.getFreeVariables();
                    if (!set.contains(((ASTLiteral)object).name)) {
                        return new Result(((ASTApply)object2).lexpr, true);
                    }
                }
            }
            object2 = IDContext.deriveContext(iDContext);
            ((IDContext)object2).addBoundedName(aSTAbstract.name);
            object = this.reduce(aSTAbstract.e, (IDContext)object2);
            if (((Result)object).reduced) {
                return new Result(new ASTAbstract(aSTAbstract.originalName, aSTAbstract.name, ((Result)object).lambda), true);
            }
            return new Result(aSTAbstract, false);
        }

        @Override
        public Result visit(ASTApply aSTApply, IDContext iDContext) {
            if (this.isRedex(aSTApply) && aSTApply.lexpr.isAbstraction()) {
                ASTAbstract aSTAbstract = (ASTAbstract)aSTApply.lexpr;
                return new Result(aSTAbstract.apply(iDContext, aSTApply.rexpr), true);
            }
            Result result = this.reduce(aSTApply.lexpr, iDContext);
            if (result.reduced) {
                return new Result(new ASTApply(result.lambda, aSTApply.rexpr), true);
            }
            result = this.reduce(aSTApply.rexpr, iDContext);
            if (result.reduced) {
                return new Result(new ASTApply(aSTApply.lexpr, result.lambda), true);
            }
            return new Result(aSTApply, false);
        }

        @Override
        public Result visit(ASTLiteral aSTLiteral, IDContext iDContext) {
            return new Result(aSTLiteral, false);
        }

        @Override
        public Result visit(ASTMacro aSTMacro, IDContext iDContext) {
            Lambda lambda;
            if (this.isRedex(aSTMacro) && (lambda = this.env.expandMacro(aSTMacro.name)) != null) {
                return new Result(lambda, true);
            }
            return new Result(aSTMacro, false);
        }

        private Result reduce(Lambda lambda, IDContext iDContext) {
            return lambda.accept(this, iDContext);
        }

        private boolean isRedex(IRedex iRedex) {
            return this.redex == iRedex;
        }
    }

    public static class Result {
        public final Lambda lambda;
        public final boolean reduced;

        public Result(Lambda lambda, boolean bl) {
            this.lambda = lambda;
            this.reduced = bl;
        }
    }
}

