/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import extgui.LineEditor;
import extgui.flatsplitpane.FlatSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import lambda.Environment;
import lambda.LambdaInterpreter;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.MacroExpander;
import lambda.ast.parser.Lexer;
import lambda.ast.parser.Parser;
import lambda.ast.parser.ParserException;
import lambda.conversion.Converter;
import lambda.gui.MainMenu;
import lambda.gui.RedexView;
import lambda.gui.macroview.MacroDefinitionView;
import lambda.system.CommandDelegate;
import lambda.system.CommandProcessor;
import util.nullable.NullableBool;
import util.nullable.NullableInt;

public class MainFrame
extends JFrame {
    private JTabbedPane tabbedPane;
    private JTextField inputField;
    private JButton buttonStep;
    private JButton buttonClear;
    private JCheckBox checkPrintStep;
    private JCheckBox checkShort;
    private JCheckBox checkDataConv;
    private JCheckBox checkAuto;
    private JCheckBox checkTraceInAuto;
    private JButton buttonStop;
    private RedexView redexView;
    private JTextArea output;
    private MacroDefinitionView macroView;
    private Environment env = Environment.getEnvironment();
    private final CommandProcessor commands = new CommandProcessor();
    private LambdaInterpreter interpreter;
    private boolean autoRunning;
    private Thread thread;

    public MainFrame() {
        this.setTitle("Lambda * Magica 3.60");
        this.setJMenuBar(new MainMenu(this));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.inputField = new LineEditor();
        this.inputField.setFont(this.env.getGUIFont());
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MainFrame.this.inputField.getText().trim();
                if (!string.isEmpty()) {
                    MainFrame.this.output.setText("");
                    MainFrame.this.inputField.setText("");
                    MainFrame.this.start(string);
                }
            }
        });
        jPanel2.add((Component)this.inputField, "Center");
        this.buttonStep = new JButton("step");
        this.buttonStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MainFrame.this.inputField.getText().trim();
                if (!string.isEmpty()) {
                    MainFrame.this.output.setText("");
                    MainFrame.this.inputField.setText("");
                    MainFrame.this.start(string);
                } else {
                    MainFrame.this.step();
                }
            }
        });
        jPanel2.add((Component)this.buttonStep, "East");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        this.output = new JTextArea();
        this.output.setEditable(false);
        this.output.setFont(this.env.getGUIFont());
        jPanel.add((Component)new JScrollPane(this.output), "Center");
        this.buttonClear = new JButton("clear output");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.output.setText("");
            }
        });
        jPanel3.add(this.buttonClear);
        JButton jButton = new JButton("clear macros");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.clearMacros();
            }
        });
        jPanel3.add(jButton);
        this.checkPrintStep = this.createOptionCheckBox("print_step", "print step");
        jPanel3.add(this.checkPrintStep);
        this.checkShort = this.createOptionCheckBox("short", "short printing");
        jPanel3.add(this.checkShort);
        this.checkDataConv = this.createOptionCheckBox("data_abstraction", "convert result as data");
        jPanel3.add(this.checkDataConv);
        this.checkAuto = this.createOptionCheckBox("auto", "auto reduction");
        jPanel3.add(this.checkAuto);
        this.checkTraceInAuto = this.createOptionCheckBox("trace", "show trace in auto mode");
        jPanel3.add(this.checkTraceInAuto);
        this.buttonStop = new JButton("stop");
        this.buttonStop.setEnabled(false);
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.thread != null) {
                    MainFrame.this.autoRunning = false;
                    try {
                        MainFrame.this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    MainFrame.this.println("- STOPPED.");
                    MainFrame.this.buttonStop.setEnabled(false);
                    MainFrame.this.thread = null;
                }
            }
        });
        jPanel3.add(this.buttonStop);
        GroupLayout groupLayout = new GroupLayout(jPanel3);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(this.checkPrintStep, 0, -1, Short.MAX_VALUE).addComponent(this.checkShort, 0, -1, Short.MAX_VALUE).addComponent(this.checkDataConv, 0, -1, Short.MAX_VALUE).addComponent(this.checkAuto, 0, -1, Short.MAX_VALUE).addComponent(this.checkTraceInAuto, 0, -1, Short.MAX_VALUE).addComponent(this.buttonStop, 0, -1, Short.MAX_VALUE).addComponent(this.buttonClear, 0, -1, Short.MAX_VALUE).addComponent(jButton, 0, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(this.checkPrintStep).addComponent(this.checkShort).addComponent(this.checkDataConv).addComponent(this.checkAuto).addComponent(this.checkTraceInAuto).addComponent(this.buttonStop).addComponent(this.buttonClear).addComponent(jButton)));
        jPanel3.setLayout(groupLayout);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("General", jPanel3);
        this.redexView = new RedexView();
        this.redexView.setBackground(Color.WHITE);
        this.redexView.setFont(this.env.getGUIFont());
        this.redexView.setMargin(5, 5, 5, 5);
        this.redexView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.step();
            }
        });
        this.tabbedPane.add("Redex", new JScrollPane(this.redexView));
        this.macroView = new MacroDefinitionView();
        this.macroView.setFont(this.env.getGUIFont());
        this.tabbedPane.addTab("Macros", this.macroView);
        final FlatSplitPane flatSplitPane = new FlatSplitPane();
        flatSplitPane.setContinuousLayout(true);
        flatSplitPane.setLeftComponent(jPanel);
        flatSplitPane.setRightComponent(this.tabbedPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                flatSplitPane.setDividerLocation(0.7);
                flatSplitPane.setResizeWeight(0.5);
            }
        });
        flatSplitPane.setDividerLocation(Short.MAX_VALUE);
        this.add(flatSplitPane);
        this.setSize(600, 500);
        this.initializeCommands();
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(521, n), "font.size.increase");
        inputMap.put(KeyStroke.getKeyStroke(107, n), "font.size.increase");
        inputMap.put(KeyStroke.getKeyStroke(59, n), "font.size.increase");
        inputMap.put(KeyStroke.getKeyStroke(45, n), "font.size.decrease");
        inputMap.put(KeyStroke.getKeyStroke(109, n), "font.size.decrease");
        inputMap.put(KeyStroke.getKeyStroke(48, n), "font.size.reset");
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put("font.size.increase", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Environment environment = Environment.getEnvironment();
                int n = environment.getInt("gui.fontsize", 12);
                if (n < 120) {
                    environment.set("gui.fontsize", n + 1);
                    MainFrame.this.setCodeFont(environment.getGUIFont());
                }
            }
        });
        actionMap.put("font.size.decrease", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Environment environment = Environment.getEnvironment();
                int n = environment.getInt("gui.fontsize", 12);
                if (5 < n) {
                    environment.set("gui.fontsize", n - 1);
                    MainFrame.this.setCodeFont(environment.getGUIFont());
                }
            }
        });
        actionMap.put("font.size.reset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Environment environment = Environment.getEnvironment();
                environment.set("gui.fontsize", 12);
                MainFrame.this.setCodeFont(environment.getGUIFont());
            }
        });
    }

    private JCheckBox createOptionCheckBox(final String string, String string2) {
        final JCheckBox jCheckBox = new JCheckBox(string2);
        jCheckBox.setSelected(this.env.getBoolean(string));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.env.set(string, jCheckBox.isSelected());
            }
        });
        return jCheckBox;
    }

    public void setCodeFont(Font font) {
        this.inputField.setFont(font);
        this.output.setFont(font);
        this.redexView.setFont(font);
        this.macroView.setFont(font.deriveFont(0, 12.0f));
    }

    private void start(String string) {
        if (this.autoRunning) {
            return;
        }
        if ((string = string.trim()).startsWith(":")) {
            if (string.startsWith(":q")) {
                this.dispose();
            } else {
                this.commands.invokeCommand(string);
            }
        } else if (!string.isEmpty()) {
            try {
                this.evalLine(string);
            }
            catch (ParserException parserException) {
                String string2 = "";
                for (int i = 0; i < parserException.column; ++i) {
                    string2 = string2 + ' ';
                }
                this.println(string);
                this.println(string2 + '^');
                this.println("- " + parserException.getMessage());
            }
        }
    }

    private boolean stepReduction() {
        IRedex iRedex = this.redexView.getSelectedRedex();
        if (iRedex != null) {
            this.interpreter.step(this.env, iRedex);
        } else {
            this.interpreter.step(this.env);
        }
        return this.interpreter.isNormal() || this.interpreter.isCyclic();
    }

    private void step() {
        if (this.interpreter == null) {
            return;
        }
        if (!this.interpreter.isNormal()) {
            boolean bl = this.stepReduction();
            Lambda lambda = this.interpreter.getLambda();
            StringBuilder stringBuilder = new StringBuilder();
            if (this.env.getBoolean("print_step")) {
                stringBuilder.append(String.format("%3d: ", this.interpreter.getStep()));
            }
            stringBuilder.append("--> ");
            if (!bl) {
                String string = lambda.toString();
                if (this.env.getBoolean("short") && string.length() > 75) {
                    stringBuilder.append(string.substring(0, 35));
                    stringBuilder.append(" ... ");
                    stringBuilder.append(string.substring(string.length() - 35, string.length()));
                } else {
                    stringBuilder.append(string);
                }
            } else {
                MacroExpander macroExpander = new MacroExpander(this.env);
                lambda = macroExpander.expand(lambda);
                stringBuilder.append(lambda.toString());
                if (this.interpreter.isNormal()) {
                    stringBuilder.append("    (normal form)");
                } else if (this.interpreter.isCyclic()) {
                    stringBuilder.append("    (cyclic reduction)");
                }
                this.buttonStop.setEnabled(false);
            }
            this.println(stringBuilder.toString());
            if (bl && this.env.getBoolean("data_abstraction")) {
                this.showConvertedData(lambda);
            }
            this.updateRedexView();
        }
    }

    private void showConvertedData(Lambda lambda) {
        NullableBool nullableBool;
        NullableInt nullableInt = Converter.toNat(lambda);
        if (nullableInt.hasValue()) {
            this.println("  = " + nullableInt + " (as nat)");
        }
        if ((nullableBool = Converter.toBool(lambda)).hasValue()) {
            this.println("  = " + nullableBool + " (as bool)");
        }
    }

    private void updateRedexView() {
        if (this.interpreter == null) {
            return;
        }
        Lambda lambda = this.interpreter.getLambda();
        this.redexView.setRedexes(lambda);
        this.redexView.revalidate();
        this.redexView.repaint();
    }

    private void defineMacro(String string, String string2) {
        try {
            Lambda lambda = MainFrame.parseExpression(string2);
            this.env.defineMacro(string, lambda);
            this.macroView.addMacro(string, lambda);
            String string3 = String.format("- <%s> is defined as %s", string, lambda);
            this.println(string3);
        }
        catch (ParserException parserException) {
            this.println("- " + parserException.getMessage());
        }
    }

    private void readMacro(String string) {
        if (string.indexOf(61) != -1) {
            String[] stringArray = string.split("\\s*=\\s*");
            if (stringArray.length == 2) {
                this.defineMacro(stringArray[0], stringArray[1]);
            } else {
                this.println("- Invalid expression: " + string);
            }
        }
    }

    private void evalLine(String string) throws ParserException {
        if (string.indexOf(61) != -1) {
            this.readMacro(string);
        } else {
            Lambda lambda = MainFrame.parseExpression(string);
            this.println(lambda.toString());
            this.interpreter = new LambdaInterpreter(lambda);
            if (!this.checkAuto.isSelected()) {
                this.tabbedPane.setSelectedIndex(1);
                this.updateRedexView();
                this.buttonStep.requestFocus();
            } else {
                this.startAuto();
            }
        }
    }

    private void startAuto() {
        this.buttonStop.setEnabled(true);
        this.thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (MainFrame.this.autoRunning) {
                        Object object;
                        boolean bl = MainFrame.this.stepReduction();
                        Lambda lambda = MainFrame.this.interpreter.getLambda();
                        StringBuilder stringBuilder = new StringBuilder();
                        if (MainFrame.this.env.getBoolean("print_step")) {
                            stringBuilder.append(String.format("%3d: ", MainFrame.this.interpreter.getStep()));
                        }
                        stringBuilder.append("--> ");
                        if (!bl && MainFrame.this.checkTraceInAuto.isSelected()) {
                            object = lambda.toString();
                            if (MainFrame.this.env.getBoolean("short") && ((String)object).length() > 75) {
                                stringBuilder.append(((String)object).substring(0, 35));
                                stringBuilder.append(" ... ");
                                stringBuilder.append(((String)object).substring(((String)object).length() - 35, ((String)object).length()));
                            } else {
                                stringBuilder.append((String)object);
                            }
                            MainFrame.this.println(stringBuilder.toString());
                            continue;
                        }
                        if (!bl) continue;
                        object = new MacroExpander(MainFrame.this.env);
                        lambda = ((MacroExpander)object).expand(lambda);
                        stringBuilder.append(lambda.toString());
                        if (MainFrame.this.interpreter.isNormal()) {
                            stringBuilder.append("    (normal form)");
                        } else if (MainFrame.this.interpreter.isCyclic()) {
                            stringBuilder.append("    (cyclic reduction)");
                        }
                        MainFrame.this.println(stringBuilder.toString());
                        if (MainFrame.this.env.getBoolean("data_abstraction")) {
                            MainFrame.this.showConvertedData(lambda);
                        }
                        MainFrame.this.autoRunning = false;
                    }
                }
                catch (StackOverflowError stackOverflowError) {
                    MainFrame.this.println("Fatal Error: generated too large structure");
                }
                finally {
                    MainFrame.this.buttonStop.setEnabled(false);
                    MainFrame.this.autoRunning = false;
                    MainFrame.this.thread = null;
                }
            }
        };
        this.thread.setName("AutoRunningThread");
        this.thread.setDaemon(true);
        this.autoRunning = true;
        this.thread.start();
    }

    private void loadFile(String string) {
        if (!string.endsWith(".lm.txt")) {
            string = string + ".lm.txt";
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            this.println("- load '" + string + "'");
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(35);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((string2 = string2.trim()).isEmpty()) continue;
                this.readMacro(string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.println("- cannot open file \"" + string + "\"");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void clearMacros() {
        this.env.clearMacros();
        this.macroView.clearList();
        this.println("- macros were cleared.");
    }

    private void initializeCommands() {
        this.commands.add(":l", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length == 0) {
                    File file = new File(".");
                    for (File file2 : file.listFiles()) {
                        if (!file2.isFile() || !file2.getName().endsWith(".lm.txt")) continue;
                        MainFrame.this.loadFile(file2.getName());
                    }
                } else {
                    for (String string : stringArray) {
                        MainFrame.this.loadFile(string);
                    }
                }
            }
        });
        this.commands.add(":f", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length >= 1) {
                    String string = "";
                    for (String string2 : stringArray) {
                        string = string + string2 + " ";
                    }
                    try {
                        Lambda parserException = MainFrame.parseExpression(string);
                        MacroExpander macroExpander = new MacroExpander(MainFrame.this.env);
                        MainFrame.this.println(macroExpander.expand(parserException).toString());
                    }
                    catch (ParserException parserException) {
                        MainFrame.this.println(parserException.getMessage());
                    }
                }
            }
        });
        this.commands.add(":c", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.clearMacros();
            }
        });
        this.commands.add(":pwd", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.println(new File("").getAbsolutePath());
            }
        });
        this.commands.add(":?", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.println("- :?         - show this help.");
                MainFrame.this.println("- :f <expr>  - expand macros and show expression.");
                MainFrame.this.println("- :l <path>  - load lines from a text file.");
                MainFrame.this.println("- :s <n>     - set the number of continuation steps.");
                MainFrame.this.println("- :t [on]    - set trace mode. ");
                MainFrame.this.println("- :c         - clear all macros.");
                MainFrame.this.println("- :pwd       - print working directory.");
                MainFrame.this.println("- :q         - quit interpreter.");
            }
        });
    }

    private synchronized void println(String string) {
        this.output.append(string);
        this.output.append(System.getProperty("line.separator"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.output.setCaretPosition(MainFrame.this.output.getText().length());
            }
        });
    }

    private static Lambda parseExpression(String string) throws ParserException {
        Parser parser = new Parser(new Lexer(string));
        return parser.parse();
    }
}

