/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.Environment;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class MacroExpander
extends Lambda.SingleVisitor<Lambda> {
    private Environment env;

    public MacroExpander(Environment environment) {
        this.env = environment;
    }

    public Lambda expand(Lambda lambda) {
        return lambda.accept(this);
    }

    @Override
    public Lambda visitAbstract(ASTAbstract aSTAbstract) {
        Lambda lambda = aSTAbstract.e.accept(this);
        return lambda == aSTAbstract.e ? aSTAbstract : new ASTAbstract(aSTAbstract.originalName, aSTAbstract.name, lambda);
    }

    @Override
    public Lambda visitApply(ASTApply aSTApply) {
        Lambda lambda = aSTApply.lexpr.accept(this);
        Lambda lambda2 = aSTApply.rexpr.accept(this);
        return lambda == aSTApply.lexpr && lambda2 == aSTApply.rexpr ? aSTApply : new ASTApply(lambda, lambda2);
    }

    @Override
    public Lambda visitLiteral(ASTLiteral aSTLiteral) {
        return aSTLiteral;
    }

    @Override
    public Lambda visitMacro(ASTMacro aSTMacro) {
        Lambda lambda = this.env.expandMacro(aSTMacro.name);
        if (lambda != null) {
            return lambda;
        }
        System.out.println("- <" + aSTMacro.name + "> is undefined");
        return aSTMacro;
    }
}

