/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import java.awt.FontMetrics;
import java.awt.Graphics;
import lambda.gui.lambdalabel.LambdaLabel;

public class LambdaLabelMetrics {
    private static MeasureVisitor visitor;

    public static int getWidth(Graphics graphics, LambdaLabel lambdaLabel) {
        if (visitor == null) {
            visitor = new MeasureVisitor(2);
        }
        return visitor.calculateSize(graphics.getFontMetrics(), lambdaLabel);
    }

    private static class MeasureVisitor
    implements LambdaLabel.VisitorRP<Integer, Boolean> {
        private FontMetrics fm;
        private int padding;

        public MeasureVisitor(int n) {
            this.padding = n;
        }

        public int calculateSize(FontMetrics fontMetrics, LambdaLabel lambdaLabel) {
            this.fm = fontMetrics;
            return lambdaLabel.accept(this, false);
        }

        @Override
        public Integer visit(LambdaLabel.LiteralLabel literalLabel, Boolean bl) {
            int n = this.getParenedWidth(literalLabel.name, bl);
            literalLabel.setWidth(n);
            return literalLabel.getWidth();
        }

        @Override
        public Integer visit(LambdaLabel.ApplyLabel applyLabel, Boolean bl) {
            boolean bl2 = applyLabel.lexpr.isAbstract();
            boolean bl3 = !applyLabel.rexpr.isAtomic();
            int n = applyLabel.lexpr.accept(this, bl2) + applyLabel.rexpr.accept(this, bl3);
            if (bl.booleanValue()) {
                n += this.getParenWidth();
            }
            applyLabel.setWidth(n);
            return n;
        }

        @Override
        public Integer visit(LambdaLabel.AbstractLabel abstractLabel, Boolean bl) {
            LambdaLabel lambdaLabel = abstractLabel;
            int n = this.fm.charWidth('\\');
            while (((LambdaLabel)lambdaLabel).isAbstract()) {
                LambdaLabel.AbstractLabel abstractLabel2 = lambdaLabel;
                n += this.fm.stringWidth(abstractLabel2.name);
                lambdaLabel = abstractLabel2.body;
            }
            n += this.fm.charWidth('.');
            n += ((LambdaLabel)lambdaLabel).accept(this, false).intValue();
            if (bl.booleanValue()) {
                n += this.getParenWidth();
            }
            abstractLabel.setWidth(n);
            return abstractLabel.getWidth();
        }

        @Override
        public Integer visit(LambdaLabel.MacroLabel macroLabel, Boolean bl) {
            int n = this.getParenedWidth("<" + macroLabel.name + ">", bl);
            macroLabel.setWidth(n);
            return macroLabel.getWidth();
        }

        @Override
        public Integer visit(LambdaLabel.RedexWrapper redexWrapper, Boolean bl) {
            int n = redexWrapper.lambda.accept(this, bl);
            redexWrapper.setWidth(n + 2 * this.padding);
            return redexWrapper.getWidth();
        }

        private int getParenWidth() {
            return this.fm.charWidth('(') + this.fm.charWidth(')');
        }

        private int getParenedWidth(String string, boolean bl) {
            int n = this.getWidth(string);
            if (bl) {
                n += this.getParenWidth();
            }
            return n;
        }

        private int getWidth(String string) {
            return this.fm.stringWidth(string);
        }
    }
}

