/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.RedexFinder;
import lambda.gui.lambdalabel.LambdaLabel;
import lambda.gui.lambdalabel.LambdaLabelBuilder;
import lambda.gui.lambdalabel.LambdaLabelDrawer;
import lambda.gui.lambdalabel.LambdaLabelMetrics;
import util.Pair;

public class RedexView
extends JPanel {
    private static final Color HOVER_BACK_COLOR = new Color(220, 220, 255);
    private static final Color SELECTION_RECT_COLOR = new Color(40, 40, 255);
    private LambdaLabelBuilder builder = new LambdaLabelBuilder();
    private List<Pair<IRedex, LambdaLabel>> labels = new ArrayList<Pair<IRedex, LambdaLabel>>();
    private Insets margin = new Insets(0, 0, 0, 0);
    private int height = 20;
    private int maxWidth;
    private int hoverIndex = -1;
    private int selectedIndex = -1;

    public RedexView() {
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.margin.set(n, n2, n3, n4);
    }

    public void clearLabels() {
        this.labels.clear();
        this.maxWidth = 0;
        this.hoverIndex = -1;
        this.selectedIndex = -1;
    }

    private void addLabel(IRedex iRedex, LambdaLabel lambdaLabel) {
        this.labels.add(Pair.of(iRedex, lambdaLabel));
        this.maxWidth = Math.max(this.maxWidth, LambdaLabelMetrics.getWidth(this.getGraphics(), lambdaLabel));
        int n = this.maxWidth + this.margin.left + this.margin.right;
        int n2 = this.height * this.labels.size() + this.margin.top + this.margin.bottom;
        this.setPreferredSize(new Dimension(n, n2));
    }

    public void setRedexes(Lambda lambda) {
        this.clearLabels();
        for (IRedex iRedex : RedexFinder.getRedexList(lambda)) {
            LambdaLabel lambdaLabel = this.builder.createLambdaLabel(lambda, iRedex);
            this.addLabel(iRedex, lambdaLabel);
        }
        this.setSelectedIndex(0);
    }

    public IRedex getSelectedRedex() {
        int n = this.getSelectedIndex();
        if (0 <= n && n < this.labels.size()) {
            return (IRedex)this.labels.get((int)n)._1;
        }
        return null;
    }

    public int getLabelCount() {
        return this.labels.size();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (0 <= n && n < this.labels.size()) {
            this.selectedIndex = n;
            this.repaint();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void dispatchActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "selected");
        for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.labels.isEmpty()) {
            String string = "No Redexes";
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.drawString(string, (this.getWidth() - n) / 2, (this.getHeight() - n2) / 2 + fontMetrics.getLeading() + fontMetrics.getAscent());
            return;
        }
        graphics.translate(this.margin.left, this.margin.top);
        int n = this.getWidth() - (this.margin.left + this.margin.right);
        if (this.hoverIndex != -1) {
            graphics.setColor(HOVER_BACK_COLOR);
            graphics.fillRect(0, this.hoverIndex * this.height, n, this.height);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        LambdaLabelDrawer lambdaLabelDrawer = new LambdaLabelDrawer();
        for (int i = 0; i < this.labels.size(); ++i) {
            Pair<IRedex, LambdaLabel> pair = this.labels.get(i);
            lambdaLabelDrawer.draw(graphics, (LambdaLabel)pair._2, 0, i * this.height, this.height);
        }
        if (this.selectedIndex != -1) {
            graphics.setColor(SELECTION_RECT_COLOR);
            graphics.drawRect(0, this.selectedIndex * this.height, n, this.height);
        }
        graphics.translate(-this.margin.left, -this.margin.top);
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateHoverIndex(mouseEvent);
            RedexView.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            RedexView.this.hoverIndex = -1;
            RedexView.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.updateHoverIndex(mouseEvent);
                RedexView.this.selectedIndex = RedexView.this.hoverIndex;
                RedexView.this.repaint();
                if (mouseEvent.getClickCount() == 2) {
                    RedexView.this.dispatchActionEvent();
                }
            }
        }

        private void updateHoverIndex(MouseEvent mouseEvent) {
            RedexView.this.hoverIndex = (mouseEvent.getY() - ((RedexView)RedexView.this).margin.top) / RedexView.this.height;
            if (RedexView.this.hoverIndex < 0 || RedexView.this.labels.size() <= RedexView.this.hoverIndex) {
                RedexView.this.hoverIndex = -1;
            }
        }
    }
}

