/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import util.Unit;

public class VariableCollector {
    private Collector collector = new Collector();

    public VariableCollector(Lambda lambda) {
        lambda.accept(this.collector);
    }

    public Set<String> getFreeVariables() {
        return Collections.unmodifiableSet(this.collector.fv);
    }

    public Set<String> getBoundedVariables() {
        return Collections.unmodifiableSet(this.collector.bv);
    }

    private static class Collector
    extends Lambda.SingleVisitor<Unit> {
        private Set<String> fv = new HashSet<String>();
        private Set<String> bv = new HashSet<String>();

        private Collector() {
        }

        @Override
        public Unit visitAbstract(ASTAbstract aSTAbstract) {
            this.bv.add(aSTAbstract.name);
            aSTAbstract.e.accept(this);
            this.fv.remove(aSTAbstract.name);
            return Unit.VALUE;
        }

        @Override
        public Unit visitApply(ASTApply aSTApply) {
            aSTApply.lexpr.accept(this);
            aSTApply.rexpr.accept(this);
            return Unit.VALUE;
        }

        @Override
        public Unit visitLiteral(ASTLiteral aSTLiteral) {
            this.fv.add(aSTLiteral.name);
            return Unit.VALUE;
        }

        @Override
        public Unit visitMacro(ASTMacro aSTMacro) {
            return Unit.VALUE;
        }
    }
}

