/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.HashSet;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import util.Unit;

public class NameGenerator {
    private static Collector collector;

    public static Set<String> getNames(Lambda lambda) {
        if (collector == null) {
            collector = new Collector();
        }
        HashSet<String> hashSet = new HashSet<String>();
        lambda.accept(collector, hashSet);
        return hashSet;
    }

    private static class Collector
    implements Lambda.Visitor<Unit, Set<String>> {
        private Collector() {
        }

        @Override
        public Unit visitAbstract(ASTAbstract aSTAbstract, Set<String> set) {
            aSTAbstract.e.accept(this, set);
            return Unit.VALUE;
        }

        @Override
        public Unit visitApply(ASTApply aSTApply, Set<String> set) {
            aSTApply.lexpr.accept(this, set);
            aSTApply.rexpr.accept(this, set);
            return Unit.VALUE;
        }

        @Override
        public Unit visitLiteral(ASTLiteral aSTLiteral, Set<String> set) {
            set.add(aSTLiteral.name);
            return Unit.VALUE;
        }

        @Override
        public Unit visitMacro(ASTMacro aSTMacro, Set<String> set) {
            return Unit.VALUE;
        }
    }
}

