/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class LambdaPrinter
extends Lambda.SingleVisitor<Lambda> {
    private static final char LAMBDA_CHAR = '\\';
    private StringBuilder buf = new StringBuilder();

    public static String toString(Lambda lambda) {
        LambdaPrinter lambdaPrinter = new LambdaPrinter();
        lambda.accept(lambdaPrinter);
        return lambdaPrinter.buf.toString();
    }

    public String makeString(Lambda lambda) {
        lambda.accept(this);
        return this.buf.toString();
    }

    @Override
    public Lambda visitAbstract(ASTAbstract aSTAbstract) {
        Lambda lambda = aSTAbstract;
        this.buf.append('\\');
        while (((Lambda)lambda).isAbstraction()) {
            ASTAbstract aSTAbstract2 = lambda;
            this.buf.append(aSTAbstract2.name);
            lambda = aSTAbstract2.e;
        }
        this.buf.append('.');
        lambda.accept(this);
        return aSTAbstract;
    }

    @Override
    public Lambda visitApply(ASTApply aSTApply) {
        boolean bl;
        Lambda lambda = aSTApply.lexpr;
        Lambda lambda2 = aSTApply.rexpr;
        boolean bl2 = lambda.isAbstraction();
        boolean bl3 = bl = !lambda2.isAtomic();
        if (bl2) {
            this.buf.append('(');
        }
        lambda.accept(this);
        if (bl2) {
            this.buf.append(')');
        }
        if (bl) {
            this.buf.append('(');
        }
        lambda2.accept(this);
        if (bl) {
            this.buf.append(')');
        }
        return aSTApply;
    }

    @Override
    public Lambda visitLiteral(ASTLiteral aSTLiteral) {
        this.buf.append(aSTLiteral.name);
        return aSTLiteral;
    }

    @Override
    public Lambda visitMacro(ASTMacro aSTMacro) {
        this.buf.append('<');
        this.buf.append(aSTMacro.name);
        this.buf.append('>');
        return aSTMacro;
    }
}

