/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class LambdaCloner {
    private static VisitorImpl visitor;

    public static Lambda copy(Lambda lambda) {
        if (visitor == null) {
            visitor = new VisitorImpl();
        }
        return lambda.accept(visitor);
    }

    private static class VisitorImpl
    extends Lambda.SingleVisitor<Lambda> {
        private VisitorImpl() {
        }

        @Override
        public Lambda visitAbstract(ASTAbstract aSTAbstract) {
            return new ASTAbstract(aSTAbstract.originalName, aSTAbstract.name, LambdaCloner.copy(aSTAbstract.e));
        }

        @Override
        public Lambda visitApply(ASTApply aSTApply) {
            return new ASTApply(LambdaCloner.copy(aSTApply.lexpr), LambdaCloner.copy(aSTApply.rexpr));
        }

        @Override
        public Lambda visitLiteral(ASTLiteral aSTLiteral) {
            return new ASTLiteral(aSTLiteral.originalName, aSTLiteral.name);
        }

        @Override
        public Lambda visitMacro(ASTMacro aSTMacro) {
            return new ASTMacro(aSTMacro.name);
        }
    }
}

