/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.Set;
import lambda.Environment;
import lambda.LambdaMatcher;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IDContext;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.VariableCollector;
import util.Pair;

public class LambdaInterpreter {
    private Lambda sourceLambda;
    private Lambda lambda;
    private boolean isEtaEnabled;
    private boolean isNormal;
    private boolean isCyclic;

    public LambdaInterpreter(Lambda lambda) {
        this.sourceLambda = lambda;
        this.initialize();
    }

    public void initialize() {
        this.lambda = this.sourceLambda;
        this.isNormal = false;
        this.isCyclic = false;
    }

    public boolean step(Environment environment) {
        if (!this.isNormal && !this.isCyclic) {
            Pair<Boolean, Lambda> pair;
            if (this.isEtaEnabled) {
                pair = this.lambda.etaReduction();
                if (((Boolean)pair._1).booleanValue()) {
                    this.lambda = (Lambda)pair._2;
                    this.isNormal = NormalFormChecker.isNormalForm(this.lambda);
                    return true;
                }
            }
            pair = this.lambda.betaReduction(IDContext.createContext(), environment);
            this.isCyclic = LambdaMatcher.structuralEquivalent(this.lambda, (Lambda)pair._2);
            this.lambda = (Lambda)pair._2;
            this.isNormal = NormalFormChecker.isNormalForm(this.lambda);
            return (Boolean)pair._1 != false && !this.isCyclic;
        }
        return false;
    }

    public boolean step(Environment environment, IRedex iRedex) {
        if (!this.isNormal && !this.isCyclic) {
            Pair<Boolean, Lambda> pair;
            if (this.isEtaEnabled) {
                pair = this.lambda.etaReduction();
                if (((Boolean)pair._1).booleanValue()) {
                    this.lambda = (Lambda)pair._2;
                    this.isNormal = NormalFormChecker.isNormalForm(this.lambda);
                    return true;
                }
            }
            pair = this.lambda.betaReduction(IDContext.createContext(), environment, iRedex);
            this.isCyclic = LambdaMatcher.structuralEquivalent(this.lambda, (Lambda)pair._2);
            this.lambda = (Lambda)pair._2;
            this.isNormal = NormalFormChecker.isNormalForm(this.lambda);
            return (Boolean)pair._1 != false && !this.isCyclic;
        }
        return false;
    }

    public boolean isNormal() {
        return this.isNormal;
    }

    public boolean isCyclic() {
        return !this.isNormal && this.isCyclic;
    }

    public boolean isTerminated() {
        return !(!this.isNormal() && !this.isCyclic() || this.isEtaEnabled && LambdaInterpreter.isEtaRedex(this.lambda));
    }

    public Lambda getLambda() {
        return this.lambda;
    }

    private static boolean isEtaRedex(Lambda lambda) {
        if (lambda.isAbstraction()) {
            ASTAbstract aSTAbstract = (ASTAbstract)lambda;
            if (aSTAbstract.e.isApplication()) {
                ASTApply aSTApply = (ASTApply)aSTAbstract.e;
                if (aSTApply.rexpr.isLiteral()) {
                    ASTLiteral aSTLiteral = (ASTLiteral)aSTApply.rexpr;
                    VariableCollector variableCollector = new VariableCollector(aSTApply.lexpr);
                    Set<String> set = variableCollector.getFreeVariables();
                    if (!set.contains(aSTLiteral.name)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static class NormalFormChecker
    extends Lambda.SingleVisitor<Boolean> {
        private static NormalFormChecker visitor;

        private NormalFormChecker() {
        }

        public static boolean isNormalForm(Lambda lambda) {
            if (visitor == null) {
                visitor = new NormalFormChecker();
            }
            return visitor.visit(lambda);
        }

        private boolean visit(Lambda lambda) {
            return lambda.accept(this);
        }

        @Override
        public Boolean visitAbstract(ASTAbstract aSTAbstract) {
            return this.visit(aSTAbstract.e);
        }

        @Override
        public Boolean visitApply(ASTApply aSTApply) {
            return !aSTApply.lexpr.isAbstraction() && this.visit(aSTApply.lexpr) && this.visit(aSTApply.rexpr);
        }

        @Override
        public Boolean visitLiteral(ASTLiteral aSTLiteral) {
            return true;
        }

        @Override
        public Boolean visitMacro(ASTMacro aSTMacro) {
            return false;
        }
    }
}

