/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui.lambdalabel;

import java.awt.Color;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.gui.lambdalabel.LambdaLabel;

public class LambdaLabelBuilder {
    private IRedex redex;
    private ConvertVisitor visitor = new ConvertVisitor();

    public LambdaLabel createLambdaLabel(Lambda lambda, IRedex iRedex) {
        this.redex = iRedex;
        return lambda.accept(this.visitor);
    }

    private class ConvertVisitor
    extends Lambda.SingleVisitor<LambdaLabel> {
        private ConvertVisitor() {
        }

        @Override
        public LambdaLabel visitAbstract(ASTAbstract aSTAbstract) {
            return LambdaLabel.abs(aSTAbstract.name, aSTAbstract.e.accept(this));
        }

        @Override
        public LambdaLabel visitApply(ASTApply aSTApply) {
            LambdaLabel lambdaLabel = aSTApply.lexpr.accept(this);
            LambdaLabel lambdaLabel2 = aSTApply.rexpr.accept(this);
            if (aSTApply == LambdaLabelBuilder.this.redex) {
                lambdaLabel = LambdaLabel.wrap(lambdaLabel, new Color(255, 120, 120, 180));
                lambdaLabel2 = LambdaLabel.wrap(lambdaLabel2, new Color(120, 120, 255, 180));
            }
            return LambdaLabel.apply(lambdaLabel, lambdaLabel2);
        }

        @Override
        public LambdaLabel visitLiteral(ASTLiteral aSTLiteral) {
            return LambdaLabel.literal(aSTLiteral.name);
        }

        @Override
        public LambdaLabel visitMacro(ASTMacro aSTMacro) {
            LambdaLabel lambdaLabel = LambdaLabel.macro(aSTMacro.name);
            if (aSTMacro == LambdaLabelBuilder.this.redex) {
                lambdaLabel = LambdaLabel.wrap(lambdaLabel, new Color(120, 255, 120, 180));
            }
            return lambdaLabel;
        }
    }
}

