/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import lambda.Environment;
import lambda.LambdaInterpreter;
import lambda.ast.ASTAbstract;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.MacroExpander;
import lambda.ast.parser.Lexer;
import lambda.ast.parser.Parser;
import lambda.ast.parser.ParserException;
import lambda.conversion.Converter;
import lambda.gui.MainMenu;
import lambda.gui.RedexView;
import lambda.gui.macroview.MacroDefinitionView;
import lambda.system.CommandDelegate;
import lambda.system.CommandProcessor;
import util.nullable.NullableBool;
import util.nullable.NullableInt;

public class MainFrame
extends JFrame {
    private JTabbedPane tabbedPane;
    private JTextField inputField;
    private JButton buttonStep;
    private JButton buttonClear;
    private JCheckBox checkShort;
    private JCheckBox checkDataConv;
    private JCheckBox checkAuto;
    private JCheckBox checkTraceInAuto;
    private JButton buttonStop;
    private RedexView redexView;
    private JTextArea output;
    private MacroDefinitionView macroView;
    private Environment env = Environment.load("properties.txt");
    private final CommandProcessor commands = new CommandProcessor();
    private LambdaInterpreter interpreter;
    private boolean autoRunning;
    private Thread thread;

    public MainFrame() {
        this.setTitle("Lambda * Magica 3.50");
        this.setJMenuBar(new MainMenu(this));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.inputField = new JTextField();
        this.inputField.setFont(new Font("Consolas", 0, 12));
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MainFrame.this.inputField.getText().trim();
                if (!string.isEmpty()) {
                    MainFrame.this.output.setText("");
                    MainFrame.this.inputField.setText("");
                    MainFrame.this.start(string);
                }
            }
        });
        jPanel2.add((Component)this.inputField, "Center");
        this.buttonStep = new JButton("step");
        this.buttonStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.step();
            }
        });
        this.buttonStep.setEnabled(false);
        jPanel2.add((Component)this.buttonStep, "East");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        this.output = new JTextArea();
        this.output.setEditable(false);
        this.output.setFont(new Font("Consolas", 0, 12));
        jPanel.add((Component)new JScrollPane(this.output), "Center");
        this.buttonClear = new JButton("clear output");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.output.setText("");
            }
        });
        jPanel3.add(this.buttonClear);
        JButton jButton = new JButton("clear macros");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.clearMacros();
            }
        });
        jPanel3.add(jButton);
        this.checkShort = new JCheckBox("short printing");
        this.checkShort.setSelected(this.env.getBoolean("short"));
        this.checkShort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.env.set("short", MainFrame.this.checkShort.isSelected());
            }
        });
        jPanel3.add(this.checkShort);
        this.checkDataConv = new JCheckBox("convert result as data");
        this.checkDataConv.setSelected(this.env.getBoolean("data_abstraction"));
        this.checkDataConv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.env.set("data_abstraction", MainFrame.this.checkDataConv.isSelected());
            }
        });
        jPanel3.add(this.checkDataConv);
        this.checkAuto = new JCheckBox("auto reduction");
        jPanel3.add(this.checkAuto);
        this.checkTraceInAuto = new JCheckBox("show trace in auto mode");
        jPanel3.add(this.checkTraceInAuto);
        this.buttonStop = new JButton("stop");
        this.buttonStop.setEnabled(false);
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.thread != null) {
                    MainFrame.this.autoRunning = false;
                    try {
                        MainFrame.this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    MainFrame.this.println("- STOPPED.");
                    MainFrame.this.buttonStop.setEnabled(false);
                    MainFrame.this.thread = null;
                }
            }
        });
        jPanel3.add(this.buttonStop);
        GroupLayout groupLayout = new GroupLayout(jPanel3);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(this.checkShort, 0, -1, Short.MAX_VALUE).addComponent(this.checkDataConv, 0, -1, Short.MAX_VALUE).addComponent(this.checkAuto, 0, -1, Short.MAX_VALUE).addComponent(this.checkTraceInAuto, 0, -1, Short.MAX_VALUE).addComponent(this.buttonStop, 0, -1, Short.MAX_VALUE).addComponent(this.buttonClear, 0, -1, Short.MAX_VALUE).addComponent(jButton, 0, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(this.checkShort).addComponent(this.checkDataConv).addComponent(this.checkAuto).addComponent(this.checkTraceInAuto).addComponent(this.buttonStop).addComponent(this.buttonClear).addComponent(jButton)));
        jPanel3.setLayout(groupLayout);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("General", jPanel3);
        this.redexView = new RedexView();
        this.redexView.setBackground(Color.WHITE);
        this.redexView.setFont(new Font("DialogInput", 0, 12));
        this.redexView.setMargin(5, 5, 5, 5);
        this.redexView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.step();
            }
        });
        this.tabbedPane.add("Redex", new JScrollPane(this.redexView));
        this.macroView = new MacroDefinitionView();
        this.tabbedPane.addTab("Macros", this.macroView);
        final JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setLeftComponent(jPanel);
        jSplitPane.setRightComponent(this.tabbedPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                jSplitPane.setDividerLocation(0.7);
                jSplitPane.setResizeWeight(0.5);
            }
        });
        this.add(jSplitPane);
        this.setSize(600, 500);
        this.initializeCommands();
    }

    private void start(String string) {
        if (this.autoRunning) {
            return;
        }
        if ((string = string.trim()).startsWith(":")) {
            if (string.startsWith(":q")) {
                this.dispose();
            } else {
                this.commands.invokeCommand(string);
            }
        } else if (!string.isEmpty()) {
            try {
                this.evalLine(string);
            }
            catch (ParserException parserException) {
                String string2 = "";
                for (int i = 0; i < parserException.column; ++i) {
                    string2 = string2 + ' ';
                }
                this.println(string);
                this.println(string2 + '^');
                this.println("- " + parserException.getMessage());
            }
        }
    }

    private boolean stepReduction() {
        IRedex iRedex = this.redexView.getSelectedRedex();
        if (iRedex != null) {
            this.interpreter.step(this.env, iRedex);
        } else {
            this.interpreter.step(this.env);
        }
        return this.interpreter.isNormal() || this.interpreter.isCyclic();
    }

    private void step() {
        if (this.interpreter == null) {
            return;
        }
        if (!this.interpreter.isNormal()) {
            boolean bl = this.stepReduction();
            Lambda lambda = this.interpreter.getLambda();
            StringBuilder stringBuilder = new StringBuilder();
            if (!bl) {
                String string = lambda.toString();
                if (this.env.getBoolean("short") && string.length() > 75) {
                    stringBuilder.append(string.substring(0, 35));
                    stringBuilder.append(" ... ");
                    stringBuilder.append(string.substring(string.length() - 35, string.length()));
                } else {
                    stringBuilder.append(string);
                }
            } else {
                MacroExpander macroExpander = new MacroExpander(this.env);
                lambda = macroExpander.expand(lambda);
                stringBuilder.append(lambda.toString());
                if (this.interpreter.isNormal()) {
                    stringBuilder.append("    (normal form)");
                } else if (this.interpreter.isCyclic()) {
                    stringBuilder.append("    (cyclic reduction)");
                }
                this.buttonStep.setEnabled(false);
                this.buttonStop.setEnabled(false);
            }
            this.println("--> " + stringBuilder.toString());
            if (bl && this.env.getBoolean("data_abstraction")) {
                this.showConvertedData(lambda);
            }
            this.updateRedexView();
        }
    }

    private void showConvertedData(Lambda lambda) {
        NullableBool nullableBool;
        NullableInt nullableInt = Converter.toNat(lambda);
        if (nullableInt.hasValue()) {
            this.println("  = " + nullableInt + " (as nat)");
        }
        if ((nullableBool = Converter.toBool(lambda)).hasValue()) {
            this.println("  = " + nullableBool + " (as bool)");
        }
    }

    private void updateRedexView() {
        if (this.interpreter == null) {
            return;
        }
        Lambda lambda = this.interpreter.getLambda();
        this.redexView.setRedexes(lambda);
        this.redexView.revalidate();
        this.redexView.repaint();
    }

    private void defineMacro(String string, String string2) {
        try {
            Lambda lambda = MainFrame.parseExpression(string2);
            this.env.defineMacro(string, lambda);
            this.macroView.addMacro(string, lambda);
            String string3 = String.format("- <%s> is defined as %s", string, lambda);
            this.println(string3);
        }
        catch (ParserException parserException) {
            this.println("- " + parserException.getMessage());
        }
    }

    private void readMacro(String string) {
        if (string.indexOf(61) != -1) {
            String[] stringArray = string.split("\\s*=\\s*");
            if (stringArray.length == 2) {
                this.defineMacro(stringArray[0], stringArray[1]);
            } else {
                this.println("- Invalid expression: " + string);
            }
        }
    }

    private void evalLine(String string) throws ParserException {
        if (string.indexOf(61) != -1) {
            this.readMacro(string);
        } else {
            Lambda lambda = MainFrame.parseExpression(string);
            this.println(lambda.toString());
            ASTAbstract.varid = 0;
            this.interpreter = new LambdaInterpreter(lambda);
            if (!this.checkAuto.isSelected()) {
                this.tabbedPane.setSelectedIndex(1);
                this.updateRedexView();
                this.buttonStep.setEnabled(true);
                this.buttonStep.requestFocus();
            } else {
                this.startAuto();
            }
        }
    }

    private void startAuto() {
        this.buttonStop.setEnabled(true);
        this.thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (MainFrame.this.autoRunning) {
                        CharSequence charSequence;
                        Object object;
                        boolean bl = MainFrame.this.stepReduction();
                        Lambda lambda = MainFrame.this.interpreter.getLambda();
                        if (!bl && MainFrame.this.checkTraceInAuto.isSelected()) {
                            object = new StringBuilder("--> ");
                            charSequence = lambda.toString();
                            if (MainFrame.this.env.getBoolean("short") && ((String)charSequence).length() > 75) {
                                ((StringBuilder)object).append(((String)charSequence).substring(0, 35));
                                ((StringBuilder)object).append(" ... ");
                                ((StringBuilder)object).append(((String)charSequence).substring(((String)charSequence).length() - 35, ((String)charSequence).length()));
                            } else {
                                ((StringBuilder)object).append((String)charSequence);
                            }
                            MainFrame.this.println(((StringBuilder)object).toString());
                            continue;
                        }
                        if (!bl) continue;
                        object = new MacroExpander(MainFrame.this.env);
                        lambda = ((MacroExpander)object).expand(lambda);
                        charSequence = new StringBuilder("--> ");
                        ((StringBuilder)charSequence).append(lambda.toString());
                        if (MainFrame.this.interpreter.isNormal()) {
                            ((StringBuilder)charSequence).append("    (normal form)");
                        } else if (MainFrame.this.interpreter.isCyclic()) {
                            ((StringBuilder)charSequence).append("    (cyclic reduction)");
                        }
                        MainFrame.this.println(((StringBuilder)charSequence).toString());
                        if (MainFrame.this.env.getBoolean("data_abstraction")) {
                            MainFrame.this.showConvertedData(lambda);
                        }
                        MainFrame.this.autoRunning = false;
                    }
                }
                finally {
                    MainFrame.this.buttonStep.setEnabled(false);
                    MainFrame.this.buttonStop.setEnabled(false);
                    MainFrame.this.autoRunning = false;
                    MainFrame.this.thread = null;
                }
            }
        };
        this.thread.setName("AutoRunningThread");
        this.thread.setDaemon(true);
        this.autoRunning = true;
        this.thread.start();
    }

    private void loadFile(String string) {
        if (!string.endsWith(".lm.txt")) {
            string = string + ".lm.txt";
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            this.println("- load '" + string + "'");
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(35);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                if ((string2 = string2.trim()).isEmpty()) continue;
                this.readMacro(string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.println("- cannot open file \"" + string + "\"");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void clearMacros() {
        this.env.clearMacros();
        this.macroView.clearList();
        this.println("- macros were cleared.");
    }

    private void initializeCommands() {
        this.commands.add(":l", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length == 0) {
                    File file = new File(".");
                    for (File file2 : file.listFiles()) {
                        if (!file2.isFile() || !file2.getName().endsWith(".lm.txt")) continue;
                        MainFrame.this.loadFile(file2.getName());
                    }
                } else {
                    for (String string : stringArray) {
                        MainFrame.this.loadFile(string);
                    }
                }
            }
        });
        this.commands.add(":f", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length >= 1) {
                    String string = "";
                    for (String string2 : stringArray) {
                        string = string + string2 + " ";
                    }
                    try {
                        Lambda parserException = MainFrame.parseExpression(string);
                        MacroExpander macroExpander = new MacroExpander(MainFrame.this.env);
                        MainFrame.this.println(macroExpander.expand(parserException).toString());
                    }
                    catch (ParserException parserException) {
                        MainFrame.this.println(parserException.getMessage());
                    }
                }
            }
        });
        this.commands.add(":c", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.clearMacros();
            }
        });
        this.commands.add(":pwd", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.println(new File("").getAbsolutePath());
            }
        });
        this.commands.add(":?", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                MainFrame.this.println("- :?         - show this help.");
                MainFrame.this.println("- :f <expr>  - expand macros and show expression.");
                MainFrame.this.println("- :l <path>  - load lines from a text file.");
                MainFrame.this.println("- :s <n>     - set the number of continuation steps.");
                MainFrame.this.println("- :t [on]    - set trace mode. ");
                MainFrame.this.println("- :c         - clear all macros.");
                MainFrame.this.println("- :pwd       - print working directory.");
                MainFrame.this.println("- :q         - quit interpreter.");
            }
        });
    }

    private synchronized void println(String string) {
        this.output.append(string);
        this.output.append(System.getProperty("line.separator"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.output.setCaretPosition(MainFrame.this.output.getText().length());
            }
        });
    }

    private static Lambda parseExpression(String string) throws ParserException {
        Parser parser = new Parser(new Lexer(string));
        return parser.parse();
    }
}

