/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.HashSet;
import java.util.Set;
import lambda.Environment;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.IDContext;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.RenameGenerator;
import lambda.ast.VariableCollector;
import util.Pair;

public class ASTAbstract
extends Lambda {
    public final String originalName;
    public final String name;
    public final Lambda e;
    public static int varid = 0;

    public ASTAbstract(String string, String string2, Lambda lambda) {
        this.originalName = string;
        this.name = string2;
        this.e = lambda;
    }

    @Override
    public boolean isAbstraction() {
        return true;
    }

    @Override
    public int getPrec() {
        return 3;
    }

    @Override
    public Pair<Boolean, Lambda> betaReduction(IDContext iDContext, Environment environment) {
        IDContext iDContext2 = IDContext.deriveContext(iDContext);
        iDContext2.addBoundedName(this.name);
        Pair<Boolean, Lambda> pair = this.e.betaReduction(iDContext2, environment);
        if (((Boolean)pair._1).booleanValue()) {
            return pair.snd(new ASTAbstract(this.originalName, this.name, (Lambda)pair._2));
        }
        return pair.snd(this);
    }

    @Override
    public Pair<Boolean, Lambda> betaReduction(IDContext iDContext, Environment environment, IRedex iRedex) {
        IDContext iDContext2 = IDContext.deriveContext(iDContext);
        iDContext2.addBoundedName(this.name);
        Pair<Boolean, Lambda> pair = this.e.betaReduction(iDContext2, environment, iRedex);
        if (((Boolean)pair._1).booleanValue()) {
            return pair.snd(new ASTAbstract(this.originalName, this.name, (Lambda)pair._2));
        }
        return pair.snd(this);
    }

    @Override
    public Pair<Boolean, Lambda> etaReduction() {
        if (this.e instanceof ASTApply) {
            ASTApply aSTApply = (ASTApply)this.e;
            if (aSTApply.rexpr instanceof ASTLiteral) {
                ASTLiteral aSTLiteral = (ASTLiteral)aSTApply.rexpr;
                VariableCollector variableCollector = new VariableCollector(aSTApply.lexpr);
                Set<String> set = variableCollector.getFreeVariables();
                if (!set.contains(aSTLiteral.name)) {
                    return Pair.of(true, aSTApply.lexpr);
                }
            }
        }
        return new Pair<Boolean, Lambda>(false, this);
    }

    @Override
    protected Lambda apply(IDContext iDContext, Lambda lambda) {
        IDContext iDContext2 = IDContext.deriveContext(iDContext);
        iDContext2.addBoundedName(this.name);
        Lambda lambda2 = this.e.substitute(iDContext2, this.name, lambda);
        return lambda2;
    }

    protected Lambda substitute2(IDContext iDContext, String string, Lambda lambda) {
        String string2 = "$" + varid++;
        ASTLiteral aSTLiteral = new ASTLiteral(this.originalName, string2);
        return new ASTAbstract(this.originalName, string2, this.e.substitute(iDContext, this.name, aSTLiteral).substitute(iDContext, string, lambda));
    }

    @Override
    protected Lambda substitute(IDContext iDContext, String string, Lambda lambda) {
        if (this.name.equals(string)) {
            return this;
        }
        VariableCollector variableCollector = new VariableCollector(lambda);
        Set<String> set = variableCollector.getFreeVariables();
        ASTAbstract aSTAbstract = this;
        if (!set.isEmpty()) {
            aSTAbstract = this.rename(iDContext, set);
        }
        IDContext iDContext2 = IDContext.deriveContext(iDContext);
        iDContext2.addBoundedName(aSTAbstract.name);
        Lambda lambda2 = aSTAbstract.e.substitute(iDContext2, string, lambda);
        return aSTAbstract == this && lambda2 == this.e ? this : new ASTAbstract(this.originalName, aSTAbstract.name, lambda2);
    }

    private ASTAbstract rename(IDContext iDContext, Set<String> set) {
        VariableCollector variableCollector = new VariableCollector(this);
        RenameGenerator renameGenerator = new RenameGenerator(set);
        HashSet<String> hashSet = new HashSet<String>(iDContext.getBoundedNames());
        hashSet.addAll(variableCollector.getBoundedVariables());
        return (ASTAbstract)renameGenerator.rename(hashSet, this);
    }

    @Override
    public <T, U> T accept(Lambda.Visitor<T, U> visitor, U u) {
        return visitor.visitAbstract(this, u);
    }
}

