/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Scanner;
import lambda.Environment;
import lambda.LambdaInterpreter;
import lambda.ast.ASTAbstract;
import lambda.ast.Lambda;
import lambda.ast.MacroExpander;
import lambda.ast.parser.Lexer;
import lambda.ast.parser.Parser;
import lambda.ast.parser.ParserException;
import lambda.conversion.Converter;
import lambda.system.CommandDelegate;
import lambda.system.CommandProcessor;
import util.nullable.NullableBool;
import util.nullable.NullableInt;

public class Main {
    private static final Environment env = Environment.load("properties.txt");
    private static final CommandProcessor commands = new CommandProcessor();

    private static char readChar() {
        String string;
        char c = ' ';
        Scanner scanner = new Scanner(System.in);
        if (scanner.hasNext() && (string = scanner.nextLine().trim()).length() > 0) {
            c = Character.toLowerCase(string.charAt(0));
        }
        return c;
    }

    private static Lambda parse(String string) {
        Parser parser = new Parser(new Lexer(string));
        try {
            return parser.parse();
        }
        catch (ParserException parserException) {
            String string2 = "";
            for (int i = 0; i < parserException.column; ++i) {
                string2 = string2 + ' ';
            }
            System.out.println(string);
            System.out.println(string2 + '^');
            System.out.println("- " + parserException.getMessage());
            return null;
        }
    }

    private static void defineMacro(String string, String string2) {
        Lambda lambda = Main.parse(string2);
        if (lambda != null) {
            env.defineMacro(string, lambda);
            String string3 = String.format("- <%s> is defined as %s", string, lambda);
            System.out.println(string3);
        }
    }

    private static void readMacroDefinition(String string, int n) {
        if (string.contains("=")) {
            String[] stringArray = string.split("\\s*=\\s*");
            if (stringArray.length == 2) {
                Main.defineMacro(stringArray[0], stringArray[1]);
            } else {
                System.out.println("- Invalid macro definition: " + string + " at line " + n);
            }
        } else {
            System.out.println("- Line " + n + " is not a macro definition");
        }
    }

    private static void evalLine(String string) {
        if (string.contains("=")) {
            Main.readMacroDefinition(string, 1);
        } else {
            Lambda lambda = Main.parse(string);
            if (lambda == null) {
                return;
            }
            System.out.println(lambda);
            ASTAbstract.varid = 0;
            LambdaInterpreter lambdaInterpreter = new LambdaInterpreter(lambda);
            int n = env.getInt("continue_steps", 500);
            int n2 = 1;
            boolean bl = false;
            while (lambdaInterpreter.step(env)) {
                if (env.getBoolean("trace")) {
                    String string2 = lambdaInterpreter.getLambda().toString();
                    if (env.getBoolean("short") && string2.length() > 75) {
                        string2 = string2.substring(0, 35) + " ... " + string2.substring(string2.length() - 35, string2.length());
                    }
                    System.out.printf("%3d: ", n2);
                    System.out.println("--> " + string2);
                }
                if (n > 0 && n2 % n == 0) {
                    char c;
                    do {
                        System.out.printf("- (%d steps done) continue?(y/n): ", n2);
                    } while ((c = Main.readChar()) != 'y' && c != 'n');
                    if (c != 'y') {
                        bl = true;
                        break;
                    }
                }
                ++n2;
            }
            MacroExpander macroExpander = new MacroExpander(env);
            System.out.print("--> " + macroExpander.expand(lambdaInterpreter.getLambda()));
            if (!bl) {
                System.out.print("    ");
                if (lambdaInterpreter.isCyclic()) {
                    System.out.print("(cyclic reduction)");
                } else {
                    System.out.print("(normal form)");
                }
            }
            System.out.println();
            if (env.getBoolean("data_abstraction")) {
                NullableBool nullableBool;
                NullableInt nullableInt = Converter.toNat(lambdaInterpreter.getLambda());
                if (nullableInt.hasValue()) {
                    System.out.println("  = " + nullableInt + " (as nat)");
                }
                if ((nullableBool = Converter.toBool(lambdaInterpreter.getLambda())).hasValue()) {
                    System.out.println("  = " + nullableBool + " (as bool)");
                }
            }
        }
    }

    private static void loadFile(String string) {
        if (!string.endsWith(".lm.txt")) {
            string = string + ".lm.txt";
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            System.out.println("- Load '" + string + "'");
            int n = 1;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n2 = string2.indexOf(35);
                if (n2 != -1) {
                    string2 = string2.substring(0, n2);
                }
                if (!(string2 = string2.trim()).isEmpty()) {
                    Main.readMacroDefinition(string2, n);
                }
                ++n;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("- Unable to open file \"" + string + "\"");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void initializeCommands() {
        commands.add(":l", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length == 0) {
                    File file = new File(".");
                    for (File file2 : file.listFiles()) {
                        if (!file2.isFile() || !file2.getName().endsWith(".lm.txt")) continue;
                        Main.loadFile(file2.getName());
                    }
                } else {
                    for (String string : stringArray) {
                        Main.loadFile(string);
                    }
                }
            }
        });
        commands.add(":f", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length >= 1) {
                    String string = "";
                    for (String string2 : stringArray) {
                        string = string + string2 + " ";
                    }
                    Parser parser = new Parser(new Lexer(string));
                    MacroExpander macroExpander = new MacroExpander(env);
                    try {
                        System.out.println(macroExpander.expand(parser.parse()));
                    }
                    catch (ParserException parserException) {
                        System.out.println(parserException.getMessage());
                    }
                }
            }
        });
        commands.add(":s", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                block7: {
                    if (stringArray.length >= 1) {
                        try {
                            int n = Integer.parseInt(stringArray[0]);
                            if (n >= 0) {
                                env.set("continue_steps", n);
                                System.out.print("- set continuation steps to ");
                                if (n != 0) {
                                    System.out.println(n);
                                } else {
                                    System.out.println("infinite");
                                }
                                break block7;
                            }
                            System.out.println("- Negative number is not allowed");
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("- Illegal number format: " + stringArray[0]);
                        }
                    } else {
                        System.out.println("- continuation steps is " + env.getInt("continue_steps", 500));
                    }
                }
            }
        });
        commands.add(":t", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                if (stringArray.length >= 1) {
                    String string = stringArray[0].toLowerCase();
                    if (string.equals("on") || string.equals("off")) {
                        boolean bl = stringArray[0].equals("on");
                        env.set("trace", bl);
                        System.out.println("- set trace " + (bl ? "on" : "off"));
                    } else {
                        System.out.println("- type 'on' or 'off' to set trace mode");
                    }
                } else {
                    System.out.println("- trace is " + (env.getBoolean("trace") ? "on" : "off"));
                }
            }
        });
        commands.add(":clear", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                env.clearMacros();
                System.out.println("- macros were cleared.");
            }
        });
        commands.add(":m", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                env.dumpMacros();
            }
        });
        commands.add(":pwd", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                System.out.println(new File("").getAbsolutePath());
            }
        });
        commands.add(":short", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                boolean bl = !env.getBoolean("short");
                env.set("short", bl);
                System.out.println("- set short mode " + (bl ? "on" : "off"));
            }
        });
        commands.add(":conv", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                boolean bl = !env.getBoolean("data_abstraction");
                env.set("data_abstraction", bl);
                System.out.println("- set data conversion mode " + (bl ? "on" : "off"));
            }
        });
        commands.add(":?", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] stringArray) {
                System.out.println("- :?            - show this help.");
                System.out.println("- :f <expr>     - expand macros.");
                System.out.println("- :l <name>     - load macro definitions from a text file.");
                System.out.println("- :l            - load *.lm.txt files in current directory.");
                System.out.println("- :s <n>        - set the number of continuation steps.");
                System.out.println("- :s            - show current number of continuation steps.");
                System.out.println("- :t (on|off)   - set trace mode. ");
                System.out.println("- :t            - show current trace mode. ");
                System.out.println("- :m            - list defined macros.");
                System.out.println("- :clear        - clear all macros.");
                System.out.println("- :pwd          - print working directory.");
                System.out.println("- :short        - toggle short print mode.");
                System.out.println("- :conv         - toggle data conversion mode.");
                System.out.println("- :q            - quit interpreter.");
            }
        });
    }

    private static void repl() {
        System.out.println("Lambda * Magica version 3.50");
        System.out.println("- Type :? to see command help");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String string;
            System.out.print("> ");
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                System.err.println("- " + iOException.getMessage());
                break;
            }
            if (string == null) break;
            if ((string = string.trim()).isEmpty()) continue;
            if (string.charAt(0) == ':') {
                if (string.startsWith(":q")) break;
                commands.invokeCommand(string);
                continue;
            }
            Main.evalLine(string);
        }
    }

    public static void main(String[] stringArray) {
        Main.initializeCommands();
        Main.repl();
    }
}

