/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class RenameVisitor
implements Lambda.Visitor<Lambda, Map<String, String>> {
    private Lambda lambda;
    private Set<String> bounded = new HashSet<String>();

    public RenameVisitor(Lambda lambda) {
        this.lambda = lambda;
    }

    public Lambda rename() {
        return this.lambda.accept(this, new HashMap());
    }

    @Override
    public Lambda visitAbstract(ASTAbstract abs, Map<String, String> renameMap) {
        ASTAbstract abs2;
        HashMap<String, String> map = new HashMap<String, String>(renameMap);
        if (this.bounded.contains(abs.originalName)) {
            abs2 = abs;
        } else {
            this.bounded.add(abs.originalName);
            map.put(abs.name, abs.originalName);
            abs2 = new ASTAbstract(abs.originalName, abs.originalName, abs.e);
        }
        Lambda e = abs2.e.accept(this, map);
        this.bounded.remove(abs.originalName);
        return e == abs2.e ? abs2 : new ASTAbstract(abs2.originalName, abs2.name, e);
    }

    @Override
    public Lambda visitApply(ASTApply app, Map<String, String> renameMap) {
        Lambda l = app.lexpr.accept(this, renameMap);
        Lambda r = app.rexpr.accept(this, renameMap);
        return l == app.lexpr && r == app.rexpr ? app : new ASTApply(l, r);
    }

    @Override
    public Lambda visitLiteral(ASTLiteral literal, Map<String, String> renameMap) {
        if (renameMap.containsKey(literal.name)) {
            return new ASTLiteral(literal.originalName, renameMap.get(literal.name));
        }
        return literal;
    }

    @Override
    public Lambda visitMacro(ASTMacro macro, Map<String, String> renameMap) {
        return macro;
    }
}

