/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.HashSet;
import java.util.Set;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import util.Unit;

public class NameGenerator {
    private static Collector collector;

    public static Set<String> getNames(Lambda lambda) {
        if (collector == null) {
            collector = new Collector();
        }
        HashSet<String> names = new HashSet<String>();
        lambda.accept(collector, names);
        return names;
    }

    private static class Collector
    implements Lambda.Visitor<Unit, Set<String>> {
        private Collector() {
        }

        @Override
        public Unit visitAbstract(ASTAbstract abs, Set<String> param) {
            abs.e.accept(this, param);
            return Unit.VALUE;
        }

        @Override
        public Unit visitApply(ASTApply app, Set<String> param) {
            app.lexpr.accept(this, param);
            app.rexpr.accept(this, param);
            return Unit.VALUE;
        }

        @Override
        public Unit visitLiteral(ASTLiteral literal, Set<String> param) {
            param.add(literal.name);
            return Unit.VALUE;
        }

        @Override
        public Unit visitMacro(ASTMacro macro, Set<String> param) {
            return Unit.VALUE;
        }
    }
}

