/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.Environment;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class MacroExpander
extends Lambda.SingleVisitor<Lambda> {
    private Environment env;

    public MacroExpander(Environment env) {
        this.env = env;
    }

    public Lambda expand(Lambda lambda) {
        return lambda.accept(this);
    }

    @Override
    public Lambda visitAbstract(ASTAbstract abs) {
        Lambda e = abs.e.accept(this);
        return e == abs.e ? abs : new ASTAbstract(abs.originalName, abs.name, e);
    }

    @Override
    public Lambda visitApply(ASTApply app) {
        Lambda e1 = app.lexpr.accept(this);
        Lambda e2 = app.rexpr.accept(this);
        return e1 == app.lexpr && e2 == app.rexpr ? app : new ASTApply(e1, e2);
    }

    @Override
    public Lambda visitLiteral(ASTLiteral literal) {
        return literal;
    }

    @Override
    public Lambda visitMacro(ASTMacro macro) {
        Lambda l = this.env.expandMacro(macro.name);
        if (l != null) {
            return l;
        }
        System.out.println("- <" + macro.name + "> is undefined");
        return macro;
    }
}

