/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.Environment;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IDContext;
import lambda.ast.LambdaPrinter;
import util.Pair;
import util.Unit;

public abstract class Lambda {
    public boolean isMacro() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isApplication() {
        return false;
    }

    public boolean isAbstraction() {
        return false;
    }

    public boolean isAtomic() {
        return this.isMacro() || this.isLiteral();
    }

    public abstract int getPrec();

    public abstract Pair<Boolean, Lambda> betaReduction(IDContext var1, Environment var2);

    public Pair<Boolean, Lambda> etaReduction() {
        return Pair.of(false, this);
    }

    protected Lambda apply(IDContext context, Lambda e) {
        return this;
    }

    protected abstract Lambda substitute(IDContext var1, String var2, Lambda var3);

    public abstract <T, U> T accept(Visitor<T, U> var1, U var2);

    public <T> T accept(SingleVisitor<T> visitor) {
        return this.accept(visitor, Unit.VALUE);
    }

    public String toString() {
        return LambdaPrinter.toString(this);
    }

    public static abstract class SingleVisitor<T>
    implements Visitor<T, Unit> {
        @Override
        public final T visitAbstract(ASTAbstract abs, Unit param) {
            return this.visitAbstract(abs);
        }

        @Override
        public final T visitApply(ASTApply app, Unit param) {
            return this.visitApply(app);
        }

        @Override
        public final T visitLiteral(ASTLiteral literal, Unit param) {
            return this.visitLiteral(literal);
        }

        @Override
        public final T visitMacro(ASTMacro macro, Unit param) {
            return this.visitMacro(macro);
        }

        public abstract T visitAbstract(ASTAbstract var1);

        public abstract T visitApply(ASTApply var1);

        public abstract T visitLiteral(ASTLiteral var1);

        public abstract T visitMacro(ASTMacro var1);
    }

    public static interface Visitor<T, U> {
        public T visitAbstract(ASTAbstract var1, U var2);

        public T visitApply(ASTApply var1, U var2);

        public T visitLiteral(ASTLiteral var1, U var2);

        public T visitMacro(ASTMacro var1, U var2);
    }
}

