/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.Environment;
import lambda.ast.IDContext;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import util.Pair;

public class ASTApply
extends Lambda
implements IRedex {
    public final Lambda lexpr;
    public final Lambda rexpr;

    public ASTApply(Lambda lexpr, Lambda rexpr) {
        this.lexpr = lexpr;
        this.rexpr = rexpr;
    }

    @Override
    public boolean isApplication() {
        return true;
    }

    @Override
    public int getPrec() {
        return 1;
    }

    @Override
    public Pair<Boolean, Lambda> betaReduction(IDContext context, Environment env) {
        if (this.lexpr.isAbstraction()) {
            return new Pair<Boolean, Lambda>(true, this.lexpr.apply(context, this.rexpr));
        }
        Pair<Boolean, Lambda> ret = this.lexpr.betaReduction(context, env);
        if (((Boolean)ret._1).booleanValue()) {
            return ret.snd(new ASTApply((Lambda)ret._2, this.rexpr));
        }
        ret = this.rexpr.betaReduction(context, env);
        if (((Boolean)ret._1).booleanValue()) {
            return ret.snd(new ASTApply(this.lexpr, (Lambda)ret._2));
        }
        return new Pair<Boolean, Lambda>(false, this);
    }

    @Override
    protected Lambda substitute(IDContext context, String name, Lambda lambda) {
        Lambda l = this.lexpr.substitute(context, name, lambda);
        Lambda r = this.rexpr.substitute(context, name, lambda);
        return l == this.lexpr && r == this.rexpr ? this : new ASTApply(l, r);
    }

    @Override
    public <T, U> T accept(Lambda.Visitor<T, U> visitor, U param) {
        return visitor.visitApply(this, param);
    }
}

