/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.util.Set;
import lambda.Environment;
import lambda.LambdaMatcher;
import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IDContext;
import lambda.ast.Lambda;
import lambda.ast.VariableCollector;
import util.Pair;

public class LambdaInterpreter {
    private Lambda sourceLambda;
    private Lambda lambda;
    private boolean isEtaEnabled;
    private boolean isNormal;
    private boolean isCyclic;

    public LambdaInterpreter(Lambda sourceLambda) {
        this.sourceLambda = sourceLambda;
        this.initialize();
    }

    public void initialize() {
        this.lambda = this.sourceLambda;
        this.isNormal = false;
        this.isCyclic = false;
    }

    public boolean step(Environment env) {
        if (!this.isNormal && !this.isCyclic) {
            Pair<Boolean, Lambda> ret;
            if (this.isEtaEnabled) {
                ret = this.lambda.etaReduction();
                if (((Boolean)ret._1).booleanValue()) {
                    this.lambda = (Lambda)ret._2;
                    this.isNormal = NormalFormChecker.isNormalForm(this.lambda);
                    return true;
                }
            }
            ret = this.lambda.betaReduction(IDContext.createContext(), env);
            this.isCyclic = LambdaMatcher.structuralEquivalent(this.lambda, (Lambda)ret._2);
            this.lambda = (Lambda)ret._2;
            this.isNormal = NormalFormChecker.isNormalForm(this.lambda);
            return (Boolean)ret._1 != false && !this.isCyclic;
        }
        return false;
    }

    public boolean isNormal() {
        return this.isNormal;
    }

    public boolean isCyclic() {
        return !this.isNormal && this.isCyclic;
    }

    public boolean isTerminated() {
        return !(!this.isNormal() && !this.isCyclic() || this.isEtaEnabled && LambdaInterpreter.isEtaRedex(this.lambda));
    }

    public Lambda getLambda() {
        return this.lambda;
    }

    private static boolean isEtaRedex(Lambda lambda) {
        if (lambda.isAbstraction()) {
            ASTAbstract abs = (ASTAbstract)lambda;
            if (abs.e.isApplication()) {
                ASTApply app = (ASTApply)abs.e;
                if (app.rexpr.isLiteral()) {
                    ASTLiteral x = (ASTLiteral)app.rexpr;
                    VariableCollector vc = new VariableCollector(app.lexpr);
                    Set<String> fv = vc.getFreeVariables();
                    if (!fv.contains(x.name)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static class NormalFormChecker
    extends Lambda.SingleVisitor<Boolean> {
        private static NormalFormChecker visitor;

        private NormalFormChecker() {
        }

        public static boolean isNormalForm(Lambda lambda) {
            if (visitor == null) {
                visitor = new NormalFormChecker();
            }
            return visitor.visit(lambda);
        }

        private boolean visit(Lambda lambda) {
            return lambda.accept(this);
        }

        @Override
        public Boolean visitAbstract(ASTAbstract abs) {
            return this.visit(abs.e);
        }

        @Override
        public Boolean visitApply(ASTApply app) {
            if (!app.lexpr.isAbstraction() && this.visit(app.lexpr) && this.visit(app.rexpr)) {
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitLiteral(ASTLiteral literal) {
            return true;
        }

        @Override
        public Boolean visitMacro(ASTMacro macro) {
            return false;
        }
    }
}

