/*
 * Decompiled with CFR 0.152.
 */
package lambda.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import lambda.Environment;
import lambda.LambdaInterpreter;
import lambda.ast.ASTAbstract;
import lambda.ast.IRedex;
import lambda.ast.Lambda;
import lambda.ast.LambdaPrinter;
import lambda.ast.MacroExpander;
import lambda.ast.RedexFinder;
import lambda.ast.parser.Lexer;
import lambda.ast.parser.Parser;
import lambda.ast.parser.ParserException;
import lambda.gui.util.GUIUtils;
import lambda.system.CommandDelegate;
import lambda.system.CommandProcessor;

public class MainFrame
extends JFrame {
    private JTextField input;
    private JButton buttonStep;
    private JButton buttonClear;
    private JButton buttonRedex;
    private JTextArea output;
    private Environment env = Environment.load("properties.txt");
    private final CommandProcessor commands = new CommandProcessor();
    private LambdaInterpreter interpreter;

    public MainFrame() {
        this.setTitle("Lambda Magica");
        this.input = new JTextField();
        this.input.setFont(new Font("Consolas", 0, 12));
        this.input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = MainFrame.this.input.getText().trim();
                if (!s.isEmpty()) {
                    MainFrame.this.start(s);
                    MainFrame.this.input.setText("");
                }
            }
        });
        this.add((Component)this.input, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(0, 1, 2, 2));
        this.add((Component)buttonPanel, "East");
        this.buttonStep = new JButton("step");
        this.buttonStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.step();
            }
        });
        buttonPanel.add(this.buttonStep);
        this.output = new JTextArea();
        this.output.setFont(new Font("Consolas", 0, 12));
        JSplitPane split = new JSplitPane();
        split.setLeftComponent(new JScrollPane());
        this.add((Component)new JScrollPane(this.output), "Center");
        this.buttonClear = new JButton("clear output");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.output.setText("");
            }
        });
        buttonPanel.add(this.buttonClear);
        this.buttonRedex = new JButton("Redex");
        this.buttonRedex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showRedex();
            }
        });
        buttonPanel.add(this.buttonRedex);
        this.setSize(400, 300);
        this.initializeCommands();
    }

    /*
     * Unable to fully structure code
     */
    private void start(String text) {
        block8: {
            if ((text = text.trim()).startsWith(":")) {
                if (text.startsWith(":q")) {
                    this.dispose();
                } else {
                    this.commands.invokeCommand(text);
                }
            } else if (!text.isEmpty()) {
                try {
                    this.evalLine(text);
                    break block8;
                }
                catch (ParserException e) {
                    s = "";
                    i = 0;
                    ** while (i < e.column)
                }
lbl-1000:
                // 1 sources

                {
                    s = String.valueOf(s) + ' ';
                    ++i;
                    continue;
                }
lbl18:
                // 1 sources

                this.println(text);
                this.println(String.valueOf(s) + '^');
                this.println("- " + e.getMessage());
            }
        }
    }

    private void step() {
        if (this.interpreter != null && !this.interpreter.isNormal()) {
            String s;
            this.interpreter.step(this.env);
            Lambda lambda = this.interpreter.getLambda();
            if (!this.interpreter.isNormal() && !this.interpreter.isCyclic()) {
                s = lambda.toString();
                if (this.env.getBoolean("short") && s.length() > 75) {
                    s = String.valueOf(s.substring(0, 35)) + " ... " + s.substring(s.length() - 35, s.length());
                }
            } else {
                MacroExpander expander = new MacroExpander(this.env);
                lambda = expander.expand(lambda);
                s = lambda.toString();
                if (this.interpreter.isNormal()) {
                    s = String.valueOf(s) + "    (normal form)";
                } else if (this.interpreter.isCyclic()) {
                    s = String.valueOf(s) + "    (cyclic reduction)";
                }
            }
            this.println("--> " + s);
        }
    }

    private void showRedex() {
        if (this.interpreter == null) {
            return;
        }
        Lambda lambda = this.interpreter.getLambda();
        List<IRedex> redexes = RedexFinder.getRedexList(lambda);
        String s = "";
        for (IRedex redex : redexes) {
            LambdaPrinter printer = new LambdaPrinter(true, redex);
            s = String.valueOf(s) + printer.makeString(lambda) + "<br/>";
        }
        s = "<html>" + s + "</html>";
        JLabel label = new JLabel(s);
        label.setOpaque(true);
        label.setBackground(Color.WHITE);
        label.setFont(new Font("DialogInput", 0, 12));
        JDialog dialog = new JDialog();
        dialog.add(new JScrollPane(label));
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    private void defineMacro(String name, String expr) {
        Parser parser = new Parser(new Lexer(expr));
        try {
            Lambda lambda = parser.parse();
            this.env.defineMacro(name, lambda);
            String s = String.format("- <%s> is defined as %s", name, lambda);
            this.println(s);
        }
        catch (ParserException e) {
            this.println("- " + e.getMessage());
        }
    }

    private void readMacro(String line) {
        if (line.contains("=")) {
            String[] v = line.split("\\s*=\\s*");
            if (v.length == 2) {
                this.defineMacro(v[0], v[1]);
            } else {
                this.println("- Invalid expression: " + line);
            }
        }
    }

    private void evalLine(String line) throws ParserException {
        if (line.contains("=")) {
            this.readMacro(line);
        } else {
            Parser parser = new Parser(new Lexer(line));
            Lambda lambda = parser.parse();
            this.println(lambda.toString());
            ASTAbstract.varid = 0;
            this.interpreter = new LambdaInterpreter(lambda);
            this.buttonStep.requestFocus();
        }
    }

    private void loadFile(String path) {
        if (!path.endsWith(".lm.txt")) {
            path = String.valueOf(path) + ".lm.txt";
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            this.println("- load '" + path + "'");
            while ((line = reader.readLine()) != null) {
                int c = line.indexOf(35);
                if (c != -1) {
                    line = line.substring(0, c);
                }
                if ((line = line.trim()).isEmpty()) continue;
                try {
                    this.evalLine(line);
                }
                catch (ParserException e) {
                    this.println("- " + e.getMessage());
                }
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            this.println("- cannot open file \"" + path + "\"");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeCommands() {
        this.commands.add(":l", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                if (params.length == 0) {
                    File cd = new File(".");
                    File[] fileArray = cd.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.isFile() && file.getName().endsWith(".lm.txt")) {
                            MainFrame.this.loadFile(file.getName());
                        }
                        ++n2;
                    }
                } else {
                    String[] stringArray = params;
                    int n = params.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String fileName = stringArray[n3];
                        MainFrame.this.loadFile(fileName);
                        ++n3;
                    }
                }
            }
        });
        this.commands.add(":f", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                if (params.length >= 1) {
                    String expr = "";
                    String[] stringArray = params;
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        expr = String.valueOf(expr) + s + " ";
                        ++n2;
                    }
                    Parser parser = new Parser(new Lexer(expr));
                    MacroExpander expander = new MacroExpander(MainFrame.this.env);
                    try {
                        MainFrame.this.println(expander.expand(parser.parse()).toString());
                    }
                    catch (ParserException e) {
                        MainFrame.this.println(e.getMessage());
                    }
                }
            }
        });
        this.commands.add(":s", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                if (params.length >= 1) {
                    try {
                        MainFrame.this.env.set("continue_steps", Integer.parseInt(params[0]));
                    }
                    catch (NumberFormatException e) {
                        MainFrame.this.println("- Illegal number format: " + params[0]);
                    }
                }
            }
        });
        this.commands.add(":t", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                boolean b = false;
                if (params.length >= 1) {
                    b = params[0].equals("on");
                }
                MainFrame.this.env.set("trace", b);
                MainFrame.this.println("- set trace " + (b ? "on" : "off"));
            }
        });
        this.commands.add(":c", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                MainFrame.this.env.clearMacros();
                MainFrame.this.println("- macros were cleared.");
            }
        });
        this.commands.add(":m", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                for (Map.Entry<String, Lambda> e : MainFrame.this.env.getDefinedMacros().entrySet()) {
                    String s = String.format("- <%s> = %s", e.getKey(), e.getValue());
                    MainFrame.this.println(s);
                }
            }
        });
        this.commands.add(":pwd", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                MainFrame.this.println(new File("").getAbsolutePath());
            }
        });
        this.commands.add(":?", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                MainFrame.this.println("- :?         - show this help.");
                MainFrame.this.println("- :f <expr>  - expand macros and show expression.");
                MainFrame.this.println("- :l <path>  - load lines from a text file.");
                MainFrame.this.println("- :s <n>     - set the number of continuation steps.");
                MainFrame.this.println("- :t [on]    - set trace mode. ");
                MainFrame.this.println("- :m         - list defined macros.");
                MainFrame.this.println("- :c         - clear all macros.");
                MainFrame.this.println("- :pwd       - print working directory.");
                MainFrame.this.println("- :q         - quit interpreter.");
            }
        });
    }

    private void println(String line) {
        this.output.append(line);
        this.output.append(System.getProperty("line.separator"));
        this.output.setCaretPosition(this.output.getText().length());
    }

    public static void main(String[] args) {
        GUIUtils.setLookAndFeelToSystem();
        MainFrame f = new MainFrame();
        f.setDefaultCloseOperation(3);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}

