/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast.parser;

import lambda.ast.parser.LexerException;
import lambda.ast.parser.Token;
import lambda.ast.parser.TokenType;

public class Lexer {
    private char[] cs;
    private int column;

    public Lexer(String text) {
        this.cs = text.toCharArray();
        this.column = 0;
    }

    public Token nextToken() throws LexerException {
        this.skipWhitespaces();
        if (this.isEnd()) {
            return new Token("$END", TokenType.END, this.column);
        }
        char c = this.peek();
        if ('a' <= c && c <= 'z') {
            int col = this.column;
            this.succ();
            return new Token(Character.toString(c), TokenType.ID, col);
        }
        if (c == '<') {
            int col = this.column;
            this.succ();
            c = this.peek();
            StringBuilder buf = new StringBuilder();
            while (!this.isEnd() && c != '>') {
                buf.append(c);
                this.succ();
                c = this.peek();
            }
            if (c == '>') {
                this.succ();
                return new Token(buf.toString(), TokenType.MACRONAME, col);
            }
            throw new LexerException("Missing '>'.", this.column);
        }
        int col = this.column;
        this.succ();
        switch (c) {
            case '\\': {
                return new Token("\\", TokenType.LAMBDA, col);
            }
            case '.': {
                return new Token(".", TokenType.DOT, col);
            }
            case '(': {
                return new Token("(", TokenType.LPAR, col);
            }
            case ')': {
                return new Token(")", TokenType.RPAR, col);
            }
        }
        throw new LexerException("Illegal character '" + c + "'.", col);
    }

    public boolean isEnd() {
        return this.column >= this.cs.length;
    }

    private void skipWhitespaces() {
        while (!this.isEnd() && Character.isWhitespace(this.peek())) {
            this.succ();
        }
    }

    private char peek() {
        return this.column < this.cs.length ? this.cs[this.column] : (char)'$';
    }

    private void succ() {
        ++this.column;
    }
}

