/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;
import util.Pair;

public class Substituter {
    private VisitorImpl visitor = new VisitorImpl();
    private int varid;

    public Lambda substitute(Lambda lambda, String name, Lambda e) {
        return this.visitor.visit(lambda, Pair.of(name, e));
    }

    private class VisitorImpl
    implements Lambda.Visitor<Lambda, Pair<String, Lambda>> {
        private VisitorImpl() {
        }

        private Lambda visit(Lambda l, Pair<String, Lambda> param) {
            return l.accept(this, param);
        }

        @Override
        public Lambda visitAbstract(ASTAbstract abs, Pair<String, Lambda> param) {
            StringBuilder stringBuilder = new StringBuilder("$");
            Substituter substituter = Substituter.this;
            int n = substituter.varid;
            substituter.varid = n + 1;
            String v = stringBuilder.append(n).toString();
            ASTLiteral fresh = new ASTLiteral(abs.originalName, v);
            Lambda e = this.visit(abs.e, new Pair<String, Lambda>(abs.name, fresh));
            e = this.visit(e, param);
            return new ASTAbstract(abs.originalName, v, e);
        }

        @Override
        public Lambda visitApply(ASTApply app, Pair<String, Lambda> param) {
            Lambda l = this.visit(app.lexpr, param);
            Lambda r = this.visit(app.rexpr, param);
            return l == app.lexpr && r == app.rexpr ? app : new ASTApply(l, r);
        }

        @Override
        public Lambda visitLiteral(ASTLiteral literal, Pair<String, Lambda> param) {
            String name = (String)param._1;
            return name.equals(literal.name) ? (Lambda)param._2 : literal;
        }

        @Override
        public Lambda visitMacro(ASTMacro macro, Pair<String, Lambda> param) {
            return macro;
        }
    }
}

