/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.IRedex;
import lambda.ast.Lambda;

public class LambdaPrinter
extends Lambda.SingleVisitor<Lambda> {
    private static final char LAMBDA_CHAR = '\\';
    private boolean highlightRedex;
    private IRedex redex;
    private StringBuilder buf = new StringBuilder();

    public LambdaPrinter() {
        this(false, null);
    }

    public LambdaPrinter(boolean highlightRedex, IRedex redex) {
        this.highlightRedex = highlightRedex;
        this.redex = redex;
    }

    public static String toString(Lambda lambda) {
        LambdaPrinter printer = new LambdaPrinter();
        lambda.accept(printer);
        return printer.buf.toString();
    }

    public String makeString(Lambda lambda) {
        lambda.accept(this);
        return this.buf.toString();
    }

    @Override
    public Lambda visitAbstract(ASTAbstract abs) {
        Lambda e = abs;
        this.buf.append('\\');
        while (((Lambda)e).isAbstraction()) {
            ASTAbstract eAbs = e;
            this.buf.append(eAbs.name);
            e = eAbs.e;
        }
        this.buf.append('.');
        e.accept(this);
        return abs;
    }

    @Override
    public Lambda visitApply(ASTApply app) {
        boolean rpar;
        Lambda l = app.lexpr;
        Lambda r = app.rexpr;
        boolean lpar = l.isAbstraction();
        boolean bl = rpar = !r.isAtomic();
        if (this.highlightRedex && app == this.redex) {
            this.buf.append("<font color=\"#ff5555\">");
        }
        if (lpar) {
            this.buf.append('(');
        }
        l.accept(this);
        if (lpar) {
            this.buf.append(')');
        }
        if (this.highlightRedex && app == this.redex) {
            this.buf.append("</font><font color=\"#5555ff\">");
        }
        if (rpar) {
            this.buf.append('(');
        }
        r.accept(this);
        if (rpar) {
            this.buf.append(')');
        }
        if (this.highlightRedex && app == this.redex) {
            this.buf.append("</font>");
        }
        return app;
    }

    @Override
    public Lambda visitLiteral(ASTLiteral literal) {
        this.buf.append(literal.name);
        return literal;
    }

    @Override
    public Lambda visitMacro(ASTMacro macro) {
        if (this.highlightRedex) {
            if (macro == this.redex) {
                this.buf.append("<font color=\"#55ff55\">");
            }
            this.buf.append("&lt;");
        } else {
            this.buf.append('<');
        }
        this.buf.append(macro.name);
        if (this.highlightRedex) {
            this.buf.append("&gt;");
            if (macro == this.redex) {
                this.buf.append("</font>");
            }
        } else {
            this.buf.append('>');
        }
        return macro;
    }
}

