/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import lambda.ast.ASTAbstract;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.ASTMacro;
import lambda.ast.Lambda;

public class LambdaCloner {
    private static VisitorImpl visitor;

    public static Lambda copy(Lambda lambda) {
        if (visitor == null) {
            visitor = new VisitorImpl();
        }
        return lambda.accept(visitor);
    }

    private static class VisitorImpl
    extends Lambda.SingleVisitor<Lambda> {
        private VisitorImpl() {
        }

        @Override
        public Lambda visitAbstract(ASTAbstract abs) {
            return new ASTAbstract(abs.originalName, abs.name, LambdaCloner.copy(abs.e));
        }

        @Override
        public Lambda visitApply(ASTApply app) {
            return new ASTApply(LambdaCloner.copy(app.lexpr), LambdaCloner.copy(app.rexpr));
        }

        @Override
        public Lambda visitLiteral(ASTLiteral literal) {
            return new ASTLiteral(literal.originalName, literal.name);
        }

        @Override
        public Lambda visitMacro(ASTMacro macro) {
            return new ASTMacro(macro.name);
        }
    }
}

